/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.geneexpbase.genemodel.SpeciesCandidates;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import de.julielab.java.utilities.spanutils.OffsetMap;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.commons.lang3.Range;

public class SpeciesMentionDistancePipe
extends Pipe {
    @Override
    public Instance pipe(Instance inst) {
        Object data = inst.getData();
        if (data instanceof TokenSequence) {
            TokenSequence ts = (TokenSequence)data;
            for (Token t : ts) {
                this.setFeatures(t);
            }
        } else {
            Token t = (Token)data;
            this.setFeatures(t);
        }
        return inst;
    }

    private void setFeatures(Token t) {
        GeneMention gm = (GeneMention)t.getProperty("gm");
        Collection occurrences = (Collection)t.getProperty("occurrences");
        String focusTaxId = (String)t.getProperty("focusTaxId");
        GeneDocument doc = gm.getGeneDocument();
        SpeciesCandidates species = doc.getSpecies();
        OffsetMap<PosTag> posTags = doc.getPosTags();
        OffsetMap<SpeciesMention> textCandidates = species.getTextCandidates();
        if (!textCandidates.isEmpty()) {
            Map.Entry<Range<Integer>, SpeciesMention> lower = doc.getNearestPreviousSpeciesMention(gm.getOffsets(), focusTaxId);
            Map.Entry<Range<Integer>, SpeciesMention> higher = doc.getNearestNextSpeciesMention(gm.getOffsets(), focusTaxId);
            NavigableMap<Range<Integer>, PosTag> lowerBetween = null;
            if (lower != null) {
                lowerBetween = posTags.restrictTo(Range.between(lower.getKey().getMaximum(), gm.getBegin()));
            }
            NavigableMap<Range<Integer>, PosTag> higherBetween = null;
            if (higher != null) {
                higherBetween = posTags.restrictTo(Range.between(gm.getEnd(), higher.getKey().getMinimum()));
            }
            if (lower != null) {
                t.setFeatureValue("DISTANCE_LOWER", lowerBetween.size());
            }
            if (higher != null) {
                t.setFeatureValue("DISTANCE_HIGHER", higherBetween.size());
            }
        }
    }
}

