/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.spi.SpeciesDocumentScoringService;
import de.julielab.speciesassignment.spi.SynonymSpeciesCooccurrenceService;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class SpeciesAPrioriScorePipe
extends Pipe {
    private transient SpeciesDocumentScoringService documentScoringService;
    private transient SynonymSpeciesCooccurrenceService speciesCooccurrenceService;
    private final Parameters parameters;

    public SpeciesAPrioriScorePipe(Parameters parameters, SpeciesDocumentScoringService speciesDocumentScoringService, SynonymSpeciesCooccurrenceService synonymSpeciesCooccurrenceService) throws IOException {
        this.documentScoringService = speciesDocumentScoringService;
        this.speciesCooccurrenceService = synonymSpeciesCooccurrenceService;
        this.parameters = parameters;
    }

    public void setDocumentScoringService(SpeciesDocumentScoringService documentScoringService) {
        this.documentScoringService = documentScoringService;
    }

    public void setSpeciesCooccurrenceService(SynonymSpeciesCooccurrenceService speciesCooccurrenceService) {
        this.speciesCooccurrenceService = speciesCooccurrenceService;
    }

    @Override
    public Instance pipe(Instance inst) {
        assert (this.documentScoringService != null) : "Services have not been set to " + this.getClass().getCanonicalName();
        assert (this.speciesCooccurrenceService != null) : "Services have not been set to " + this.getClass().getCanonicalName();
        Object data = inst.getData();
        Token t = (Token)data;
        this.setFeatures(t, (GeneMention)inst.getProperty("gm"));
        return inst;
    }

    private void setFeatures(Token t, GeneMention gm) {
        String focusTax = (String)t.getProperty("focusTaxId");
        if (this.parameters.getBoolean(Configuration.dot("species_assignment", "ml", "use_syn_tax_score_feature"))) {
            this.setSynonymScore(t, gm, focusTax);
        }
        this.setAllDocumentSynonymsScore(t, gm, focusTax);
        if (this.parameters.getBoolean(Configuration.dot("species_assignment", "ml", "use_docleveltax_score_feature"))) {
            this.setDocLevelTaxScore(t, gm, focusTax);
        }
    }

    private void setDocLevelTaxScore(Token t, GeneMention gm, String focusTax) {
        Map<String, Double> documentLevelTaxonomyScores = this.documentScoringService.computeTaxDocScores(gm.getGeneDocument(), this.parameters);
        if (documentLevelTaxonomyScores.containsKey(focusTax)) {
            t.setFeatureValue("DOC_LEVEL_TAX_SCORE", documentLevelTaxonomyScores.get(focusTax));
        }
    }

    private void setAllDocumentSynonymsScore(Token t, GeneMention gm, String focusTax) {
        Optional<Pair<String, Double>> allSynonymsAprioriScore = this.speciesCooccurrenceService.getBestDocumentLevelAPrioriTaxId(gm.getGeneDocument(), Set.of(focusTax), this.parameters);
        if (allSynonymsAprioriScore.isPresent()) {
            t.setFeatureValue("DOC_SYNS_SCORE", allSynonymsAprioriScore.get().getRight());
        }
    }

    private void setSynonymScore(Token t, GeneMention gm, String focusTax) {
        Set<Pair<String, Double>> synonymAprioriScore = this.speciesCooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, null, Set.of(focusTax), this.parameters);
        Optional<Pair> highestScoredSynonym = synonymAprioriScore.stream().sorted(Comparator.comparingDouble(Pair::getRight).reversed()).findFirst();
        if (highestScoredSynonym.isPresent()) {
            t.setFeatureValue("SYN_TAX_SCORE", (Double)highestScoredSynonym.get().getRight());
        }
    }
}

