/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.geneexpbase.genemodel.PosTag;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import java.util.Collection;
import java.util.NavigableMap;
import org.apache.commons.lang3.Range;

public class PosNGRamPipe
extends Pipe {
    @Override
    public Instance pipe(Instance inst) {
        Token t = (Token)inst.getData();
        GeneMention gm = (GeneMention)t.getProperty("gm");
        String focusTax = (String)t.getProperty("focusTaxId");
        GeneDocument geneDocument = gm.getGeneDocument();
        for (String tax : gm.getTaxonomyOccurrences().keySet()) {
            PosTag nextpos;
            PosTag thispos;
            int i;
            PosTag[] posTags;
            Range<Integer> sentence;
            if (!tax.equals(focusTax)) continue;
            Collection<GeneSpeciesOccurrence> geneSpeciesOccurrences = gm.getTaxonomyOccurrences().get(tax);
            if (geneSpeciesOccurrences.contains((Object)GeneSpeciesOccurrence.SENTENCE_PRECED)) {
                sentence = geneDocument.getOverlappingSentence(gm);
                NavigableMap<Range<Integer>, SpeciesMention> speciesInSentenceBeforeGm = geneDocument.getSpecies().getAllMentionCandidates().getOverlapping(Range.between(sentence.getMinimum(), gm.getBegin()));
                for (SpeciesMention species : speciesInSentenceBeforeGm.values()) {
                    if (!species.getTaxId().equals(focusTax)) continue;
                    posTags = geneDocument.getOverlappingPosTags(Range.between(species.getOffsets().getMaximum(), gm.getBegin())).toArray(new PosTag[0]);
                    for (i = 0; i < posTags.length; ++i) {
                        thispos = posTags[i];
                        t.setFeatureValue("POS_UNI=" + thispos.getTag(), 1.0);
                        if (i + 1 >= posTags.length) continue;
                        nextpos = posTags[i + 1];
                        t.setFeatureValue("POS_BI=" + thispos.getTag() + "-" + nextpos.getTag(), 1.0);
                    }
                }
            }
            if (!geneSpeciesOccurrences.contains((Object)GeneSpeciesOccurrence.SENTENCE_SUCCED)) continue;
            sentence = geneDocument.getOverlappingSentence(gm);
            NavigableMap<Range<Integer>, SpeciesMention> speciesInSentenceAfterGm = geneDocument.getSpecies().getAllMentionCandidates().getOverlapping(Range.between(gm.getEnd(), sentence.getMaximum()));
            for (SpeciesMention species : speciesInSentenceAfterGm.values()) {
                if (!species.getTaxId().equals(focusTax)) continue;
                posTags = geneDocument.getOverlappingPosTags(Range.between(gm.getEnd(), species.getOffsets().getMinimum())).toArray(new PosTag[0]);
                for (i = 0; i < posTags.length; ++i) {
                    thispos = posTags[i];
                    t.setFeatureValue("POS_UNI=" + thispos.getTag(), 1.0);
                    if (i + 1 >= posTags.length) continue;
                    nextpos = posTags[i + 1];
                    t.setFeatureValue("POS_BI=" + thispos.getTag() + "-" + nextpos.getTag(), 1.0);
                }
            }
        }
        return inst;
    }
}

