/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.speciesassignment.mlcandidateranker.SpeciesInstanceTools;
import java.util.List;

public class NameSimilarityPipe
extends Pipe {
    public static final String NAME_SIMILARITY = "NAME_SIMILARITY";
    private final SpeciesInstanceTools instanceTools;
    private final transient CandidateRetrieval candidateRetrieval;
    private final QueryGenerator queryGenerator;

    public NameSimilarityPipe(SpeciesInstanceTools instanceTools, CandidateRetrieval candidateRetrieval, QueryGenerator queryGenerator) {
        this.instanceTools = instanceTools;
        this.candidateRetrieval = candidateRetrieval;
        this.queryGenerator = queryGenerator;
    }

    @Override
    public Instance pipe(Instance inst) {
        Object data = inst.getData();
        if (data instanceof TokenSequence) {
            TokenSequence ts = (TokenSequence)data;
            ts.forEach(t -> this.addFeatures((Token)t, inst));
        } else {
            this.addFeatures((Token)data, inst);
        }
        return inst;
    }

    private void addFeatures(Token token, Instance inst) {
        String focusTaxId;
        GeneMention gm = (GeneMention)token.getProperty("gm");
        List<SynHit> candidates = this.candidateRetrieval.getCandidates(gm, List.of(focusTaxId = (String)token.getProperty("focusTaxId")), this.queryGenerator);
        if (candidates.isEmpty()) {
            token.setFeatureValue(NAME_SIMILARITY, 0.0);
            inst.setProperty("perfectMatch", false);
        } else {
            SynHit synHit = candidates.get(0);
            if (synHit.isExactMatch()) {
                token.setFeatureValue(NAME_SIMILARITY, 1.0);
                inst.setProperty("bestsynonym", synHit.getSynonym());
                inst.setProperty("perfectMatch", true);
            } else {
                String hitSynonym = synHit.getSynonym();
                String geneText = gm.getNormalizedText();
                token.setFeatureValue(NAME_SIMILARITY, synHit.getLexicalScore());
                inst.setProperty("bestsynonym", hitSynonym);
                inst.setProperty("perfectMatch", false);
            }
        }
    }
}

