/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.types.InstanceList;
import de.julielab.geneexpbase.classification.FeatureUtils;
import de.julielab.geneexpbase.classification.MinMaxScalingStats;
import de.julielab.geneexpbase.classification.StandardizationStats;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.configuration.Parameters;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureNormalization
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(FeatureNormalization.class);
    private final String prefix;

    public FeatureNormalization(String prefix) {
        this.prefix = prefix;
    }

    public void applyFeatureNormalization(InstanceList testInstances, Parameters parameterMap) {
        Serializable normalizationValues;
        if (parameterMap.getBoolean(Configuration.dot(this.prefix, "standardize_features"))) {
            log.trace("Applying test feature standardization (Z-score normalization)");
            normalizationValues = (StandardizationStats)parameterMap.get(Configuration.dot(this.prefix, "standardization_values"));
            FeatureUtils.standardizeFeatures(testInstances, normalizationValues);
        }
        if (parameterMap.getBoolean(Configuration.dot(this.prefix, "minmax_scale_features"))) {
            log.trace("Applying test feature min-max scaling (potentially on the already Z-score normalized data).");
            normalizationValues = (MinMaxScalingStats)parameterMap.get(Configuration.dot(this.prefix, "minmax_scaling_values"));
            FeatureUtils.rangeScaleFeatures(testInstances, (MinMaxScalingStats)normalizationValues);
        }
    }
}

