/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.mlcandidateranker;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Label;
import cc.mallet.types.LabelAlphabet;
import cc.mallet.types.LabelSequence;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.speciesassignment.mlcandidateranker.SpeciesInstanceTools;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class Document2SpeciesTokenSequencePipe
extends Pipe {
    private final SpeciesInstanceTools speciesInstanceTools;

    public Document2SpeciesTokenSequencePipe(SpeciesInstanceTools speciesInstanceTools) {
        this.setTargetAlphabet(new LabelAlphabet());
        this.speciesInstanceTools = speciesInstanceTools;
    }

    @Override
    public Instance pipe(Instance inst) {
        Pair docFocusTaxPair = (Pair)inst.getData();
        List sortedGenes = ((GeneDocument)docFocusTaxPair.getLeft()).getGenes().sorted(Comparator.comparingInt(GeneMention::getBegin)).collect(Collectors.toList());
        TokenSequence ts = new TokenSequence();
        LabelSequence ls = new LabelSequence(this.getTargetAlphabet());
        for (int i = 0; i < sortedGenes.size(); ++i) {
            GeneMention gm = (GeneMention)sortedGenes.get(i);
            Pair<Token, Label> labeledSpeciesCandidateToken = this.speciesInstanceTools.createLabeledSpeciesCandidateToken(gm, (String)docFocusTaxPair.getRight(), (LabelAlphabet)this.getTargetAlphabet());
            ts.add(labeledSpeciesCandidateToken.getLeft());
            ls.add(labeledSpeciesCandidateToken.getRight().getEntry());
        }
        inst.setData(ts);
        inst.setTarget(ls);
        inst.setName(docFocusTaxPair.getRight());
        return inst;
    }
}

