/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.ioc;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import de.julielab.geneexpbase.ioc.BaseModule;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.GNormPlusGeneSpeciesExtendedAssigner;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.candidateretrieval.CandidateSetterForSpeciesTagger;
import de.julielab.speciesassignment.mlcandidateranker.SpeciesInstanceTools;
import de.julielab.speciesassignment.services.SpeciesAssignmentFilterImpl;
import de.julielab.speciesassignment.services.SpeciesAssignmentSentenceSmoothing;
import de.julielab.speciesassignment.services.SpeciesDocumentScoringServiceImpl;
import de.julielab.speciesassignment.services.SpeciesReferenceMapperImpl;
import de.julielab.speciesassignment.services.SynonymSpeciesCooccurrenceServiceImpl;
import de.julielab.speciesassignment.spi.SpeciesAssignmentFilter;
import de.julielab.speciesassignment.spi.SpeciesDocumentScoringService;
import de.julielab.speciesassignment.spi.SpeciesReferenceMapper;
import de.julielab.speciesassignment.spi.SynonymSpeciesCooccurrenceService;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Named;
import javax.inject.Singleton;

public class SpeciesAssignmentModule
extends AbstractModule {
    private final de.julielab.geneexpbase.configuration.Configuration configuration;

    public SpeciesAssignmentModule(de.julielab.geneexpbase.configuration.Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(Configuration.class).toInstance(new Configuration(this.configuration));
        this.bind(SynonymSpeciesCooccurrenceService.class).to(SynonymSpeciesCooccurrenceServiceImpl.class).in(Singleton.class);
        this.bind(SpeciesDocumentScoringService.class).to(SpeciesDocumentScoringServiceImpl.class).in(Singleton.class);
        this.bind(SpeciesAssignmentFilter.class).to(SpeciesAssignmentFilterImpl.class).in(Singleton.class);
        this.bind(SpeciesReferenceMapper.class).to(SpeciesReferenceMapperImpl.class).in(Singleton.class);
        this.bind(SpeciesAssignmentSentenceSmoothing.class);
        this.bind(GeneSpeciesAssigner.class).to(GNormPlusGeneSpeciesExtendedAssigner.class);
        this.bind(CandidateSetterForSpeciesTagger.class);
        this.bind(SpeciesInstanceTools.class);
        this.install(new BaseModule(this.configuration));
    }

    @Provides
    @Named(value="synonymSpeciesOccurrencesFile")
    File provideSynonymSpeciesCooccurrenceFile() {
        return Path.of("/synonym_species_occurrences.tsv.gz", new String[0]).toFile();
    }

    @Provides
    String provideTaxFrequencyFileLocation() {
        return "taxonomy_freq_gnormplus.txt";
    }

    @Provides
    @Named(value="mlSpeciesAssignerModelFile")
    File provideMlSpeciesAssignerModelFile(Configuration configuration) {
        String path = (String)configuration.getOrDefault((Object)Configuration.dot("species_assignment", "model"), (Object)null);
        if (path != null && !path.isBlank()) {
            return new File(path);
        }
        return null;
    }
}

