/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.hpo;

import de.julielab.geneexpbase.hpo.HttpParamOptClient;
import de.julielab.smac.FullyEvaluatedConfiguration;
import de.julielab.smac.SmacLiveRundataCollection;
import de.julielab.smac.SmacLiveRundataCollectionReader;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.hpo.SaHpoServer;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrintBestSmacConfiguration {
    private static final Map<String, String> legacyParameterMap = Map.of("species_assignmentDalgorithm", "species_assignmentDmlDalgorithm", "species_assignmentDminmax_scale_features", "species_assignmentDmlDminmax_scale_features", "species_assignmentDstandardize_features", "species_assignmentDmlDstandardize_features");

    public static void main(String[] args) throws Exception {
        int port = 32100;
        SaHpoServer.main(new String[]{String.valueOf(port)});
        SmacLiveRundataCollectionReader collectionReader = new SmacLiveRundataCollectionReader();
        String smacDataPath = "smac-output-species-round5/species_assignment_ml_me";
        SmacLiveRundataCollection collection = collectionReader.read(new File(smacDataPath));
        List<FullyEvaluatedConfiguration> bestConfigurations = collection.getBestFullyEvaluatedConfigurations(1);
        if (bestConfigurations.isEmpty()) {
            System.err.println("No evaluated configurations found.");
        }
        for (FullyEvaluatedConfiguration c : bestConfigurations) {
            System.out.println(c.getPcid() + ": " + c.getAvgQuality());
            Map<String, String> settings = c.getConfiguration().getSettings();
            ArrayList<String> keysToRemove = new ArrayList<String>();
            HashMap<String, String> settingsWithChangedKey = new HashMap<String, String>();
            for (String k : settings.keySet()) {
                if (!legacyParameterMap.containsKey(k)) continue;
                settingsWithChangedKey.put(legacyParameterMap.get(k), settings.get(k));
                keysToRemove.add(k);
            }
            keysToRemove.forEach(settings::remove);
            settings.putAll(settingsWithChangedKey);
            for (String k : settings.keySet()) {
                System.out.println(k + " = " + settings.get(k));
            }
            Map<String, Object> settingsAsConfigurationMap = c.getConfiguration().getSettingsAsConfigurationMap();
            settingsAsConfigurationMap.put("-species_assigner", "de.julielab.speciesassignment.mlcandidateranker.MLSpeciesAssigner");
            settingsAsConfigurationMap.put(Configuration.dot("species_assignment", "ml", "use_syn_tax_score_feature"), "true");
            settingsAsConfigurationMap.put(Configuration.dot("species_assignment", "ml", "use_docleveltax_score_feature"), "true");
            String devScore = HttpParamOptClient.requestScoreFromServer(settingsAsConfigurationMap, "speciescustom-all-dev", "", "get_species_custom_eval_score", port);
            System.out.println("Dev score: " + devScore);
            System.out.println();
        }
        System.exit(0);
    }
}

