/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.evaluation;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.speciesassignment.evaluation.SpeciesCountDocument;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SpeciesCrossValPartition
extends ArrayList<SpeciesCountDocument> {
    private final Multiset<String> taxIdCounts = HashMultiset.create();

    @Override
    public boolean add(SpeciesCountDocument geneDocument) {
        this.taxIdCounts.addAll(geneDocument.getTaxCounts());
        return super.add(geneDocument);
    }

    public Deque<String> getTaxesOrderedByFrequency(Set<String> allTaxIds) {
        List unseenTaxes = allTaxIds.stream().filter(Predicate.not(this.taxIdCounts::contains)).collect(Collectors.toList());
        ArrayDeque<String> taxes = new ArrayDeque<String>();
        taxes.addAll(unseenTaxes);
        this.taxIdCounts.elementSet().stream().sorted(Comparator.comparingInt(tax -> this.taxIdCounts.count(tax))).forEach(taxes::add);
        return taxes;
    }

    public Multiset<String> getTaxIdCounts() {
        return this.taxIdCounts;
    }
}

