/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.evaluation;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import java.util.Collection;
import java.util.Iterator;

public class SpeciesCountDocument {
    private final GeneDocument document;
    private final Multiset<String> taxCounts = HashMultiset.create();

    public SpeciesCountDocument(GeneDocument document) {
        this.document = document;
        this.countTaxIds(document);
    }

    public Multiset<String> getTaxCounts() {
        return this.taxCounts;
    }

    public int getCount(String taxId) {
        return this.taxCounts.count(taxId);
    }

    private void countTaxIds(GeneDocument document) {
        Iterator gmIt = null;
        try {
            gmIt = document.getGoldGenes().values().stream().flatMap(Collection::stream).iterator();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        while (gmIt.hasNext()) {
            GeneMention gm = (GeneMention)gmIt.next();
            this.taxCounts.add(gm.getIds().get(0));
        }
    }

    public GeneDocument getDocument() {
        return this.document;
    }

    public String getId() {
        return this.document.getId();
    }

    public String toString() {
        return this.getId();
    }
}

