/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.evaluation;

import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.java.utilities.Color;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SpeciesAssignmentCorrectnessRenderer {
    public static String renderCorrectTaxonomyGeneMention(GeneMention gm) {
        return Color.GREEN + gm.getText() + " [TaxId: " + gm.getTaxonomyIds().stream().collect(Collectors.joining(", ")) + " (GeneId: " + gm.getAllGoldIdsAsList().stream().collect(Collectors.joining(", ")) + ")]" + Color.RESET;
    }

    public static String renderWrongTaxonomyGeneMention(GeneMention gm, CandidateRetrieval candidateRetrieval, QueryGenerator queryGenerator) {
        Set<String> correctTaxIds;
        if (gm.getGeneDocument().isGoldHasOffsets()) {
            correctTaxIds = gm.getAllGoldTaxonomyIdsAsSet();
        } else {
            List<SynHit> candidates = candidateRetrieval.getCandidates(gm, gm.getGeneDocument().getGoldTaxonomyIds(), queryGenerator);
            correctTaxIds = candidates.stream().filter(SynHit::isExactMatch).map(SynHit::getTaxId).collect(Collectors.toSet());
        }
        return Color.RED + gm.getText() + " [TaxId: " + gm.getTaxonomyIds().stream().collect(Collectors.joining(", ")) + " | Correct: " + Color.CYAN + correctTaxIds.stream().collect(Collectors.joining(", ")) + " (GeneId: " + gm.getAllGoldIdsAsList().stream().collect(Collectors.joining(", ")) + ")" + Color.RED + "]" + Color.RESET;
    }

    public static String renderWrongTaxonomyGeneMention(GeneMention gm) {
        return Color.RED + gm.getText() + " [TaxId: " + gm.getTaxonomyIds().stream().collect(Collectors.joining(", ")) + " | Correct: " + Color.CYAN + (gm.getGeneDocument().isGoldHasOffsets() ? String.join((CharSequence)", ", gm.getAllGoldTaxonomyIdsAsList()) : "<doc level ids>") + Color.RED + "]" + Color.RESET;
    }

    public static String renderNoCorrectCandidateTaxonomyGeneMention(GeneMention gm) {
        return Color.YELLOW + gm.getText() + " [TaxId: " + gm.getTaxonomyIds().stream().collect(Collectors.joining(", ")) + ", No correct candidate]" + Color.RESET;
    }
}

