/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.cooccurrence;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SynonymSpeciesCoocurrenceCacheKey
implements Serializable {
    private final String synonym;
    private Set<String> filterTax;
    private final double docWeight;
    private final double meshWeight;
    private final double sentWeight;

    public SynonymSpeciesCoocurrenceCacheKey(String synonym, Set<String> filterTax, double docWeight, double meshWeight, double sentWeight) {
        this.synonym = synonym;
        if (filterTax != null) {
            this.filterTax = new HashSet<String>(filterTax);
        }
        this.docWeight = docWeight;
        this.meshWeight = meshWeight;
        this.sentWeight = sentWeight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynonymSpeciesCoocurrenceCacheKey cacheKey = (SynonymSpeciesCoocurrenceCacheKey)o;
        return Double.compare(cacheKey.docWeight, this.docWeight) == 0 && Double.compare(cacheKey.meshWeight, this.meshWeight) == 0 && Double.compare(cacheKey.sentWeight, this.sentWeight) == 0 && this.synonym.equals(cacheKey.synonym) && Objects.equals(this.filterTax, cacheKey.filterTax);
    }

    public int hashCode() {
        return Objects.hash(this.synonym, this.filterTax, this.docWeight, this.meshWeight, this.sentWeight);
    }
}

