/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.cooccurrence;

import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.Acronym;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.geneexpbase.genemodel.SpeciesMention;
import de.julielab.geneexpbase.scoring.JaroWinklerScorer;
import de.julielab.geneexpbase.scoring.Scorer;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.GeneCompatibleTaxFilter;
import de.julielab.speciesassignment.spi.SynonymSpeciesCooccurrenceService;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class SingularCooccurrenceAssignment {
    private final SynonymSpeciesCooccurrenceService cooccurrenceService;
    private final GeneCompatibleTaxFilter geneCompatibleTaxFilter;
    private final Scorer scorer;

    @Inject
    public SingularCooccurrenceAssignment(SynonymSpeciesCooccurrenceService synonymSpeciesCooccurrenceService, GeneCompatibleTaxFilter geneCompatibleTaxFilter) {
        this.cooccurrenceService = synonymSpeciesCooccurrenceService;
        this.geneCompatibleTaxFilter = geneCompatibleTaxFilter;
        this.scorer = new JaroWinklerScorer();
    }

    public void assignSingular(GeneDocument document, Parameters parameterMap) {
        document.expectState(EnumSet.of(GeneDocument.State.SPECIES_CANDIDATES_ASSIGNED));
        boolean restrictToCurrentScope = parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_USE_MATCHING_SCOPE_COUNT);
        for (GeneMention gm : document.getGenesIterable()) {
            if (!gm.getTaxonomyCandidates().isEmpty()) continue;
            Set<String> finalTaxIds = new HashSet<String>();
            finalTaxIds = this.assignSpeciesPrefix(gm, finalTaxIds);
            finalTaxIds = this.assignSingularInCompound(gm, finalTaxIds);
            finalTaxIds = this.assignSingularSentence(gm, finalTaxIds, restrictToCurrentScope, parameterMap);
            finalTaxIds = this.assignSingularTitle(gm, finalTaxIds, parameterMap);
            finalTaxIds = this.assignSingularDocument(gm, finalTaxIds, restrictToCurrentScope, document, parameterMap);
            finalTaxIds = this.assignSingularMeSH(gm, finalTaxIds, restrictToCurrentScope, document, parameterMap);
            gm.setTaxonomyCandidates(finalTaxIds);
            gm.setTaxonomyIds(new ArrayList<String>(finalTaxIds));
        }
    }

    private Set<String> assignSpeciesPrefix(GeneMention gm, Set<String> finalTaxIds) {
        Multimap<String, GeneSpeciesOccurrence> taxonomyOcurrences = gm.getTaxonomyOccurrences();
        if (finalTaxIds.isEmpty() && taxonomyOcurrences.values().contains((Object)GeneSpeciesOccurrence.SPECIES_PREFIX)) {
            for (String taxId : taxonomyOcurrences.keySet()) {
                if (!taxonomyOcurrences.get(taxId).contains((Object)GeneSpeciesOccurrence.SPECIES_PREFIX)) continue;
                finalTaxIds.add(taxId);
            }
        }
        return finalTaxIds;
    }

    private Set<String> assignSingularMeSH(GeneMention gm, Set<String> finalTaxIds, boolean restrictToCurrentScope, GeneDocument document, Parameters parameterMap) {
        if (finalTaxIds.isEmpty() && parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_FROM_MESH)) {
            this.cooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, restrictToCurrentScope ? SynonymSpeciesCooccurrenceService.Scope.MESH : null, document.getSpecies().getMeshCandidates(), parameterMap).stream().map(Pair::getLeft).forEach(finalTaxIds::add);
            finalTaxIds = this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates(gm, finalTaxIds, this.scorer, parameterMap);
        }
        return finalTaxIds;
    }

    private Set<String> assignSingularTitle(GeneMention gm, Set<String> finalTaxIds, Parameters parameterMap) {
        if (finalTaxIds.isEmpty() && parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_FROM_TITLE)) {
            Multimap<String, GeneSpeciesOccurrence> taxonomyOccurrences = gm.getTaxonomyOccurrences();
            for (String taxId : taxonomyOccurrences.keySet()) {
                if (!taxonomyOccurrences.get(taxId).contains((Object)GeneSpeciesOccurrence.TITLE)) continue;
                finalTaxIds.add(taxId);
            }
        }
        return finalTaxIds;
    }

    private Set<String> assignSingularDocument(GeneMention gm, Set<String> finalTaxIds, boolean restrictToCurrentScope, GeneDocument document, Parameters parameterMap) {
        if (parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_ASSIGN_SINGULAR_FROM_DOCUMENT)) {
            if (finalTaxIds.isEmpty() && !parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_USE_GLOBAL_DOCUMENT)) {
                Map.Entry<Range<Integer>, SpeciesMention> nearestPreviousSpeciesMentionInDocument = document.getNearestPreviousSpeciesMention(gm.getOffsets());
                if (nearestPreviousSpeciesMentionInDocument != null) {
                    finalTaxIds.add(nearestPreviousSpeciesMentionInDocument.getValue().getTaxId());
                }
                finalTaxIds = this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates(gm, finalTaxIds, this.scorer, parameterMap);
            }
            if (finalTaxIds.isEmpty()) {
                SynonymSpeciesCooccurrenceService.Scope documentScope = restrictToCurrentScope ? SynonymSpeciesCooccurrenceService.Scope.DOCUMENT : null;
                finalTaxIds = this.cooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, documentScope, document.getSpecies().getTextCandidates().values().stream().map(SpeciesMention::getTaxId).collect(Collectors.toSet()), parameterMap).stream().map(Pair::getLeft).collect(Collectors.toSet());
                finalTaxIds = this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates(gm, finalTaxIds, this.scorer, parameterMap);
            }
        }
        return finalTaxIds;
    }

    @NotNull
    private Set<String> assignSingularSentence(GeneMention gm, Set<String> finalTaxIds, boolean restrictToCurrentScope, Parameters parameterMap) {
        if (finalTaxIds.isEmpty() && parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_FROM_PRECEDING_SAME_SENTENCE)) {
            Set<String> taxInSentencePreceding = this.getTaxIdsWithOccurrence(gm, GeneSpeciesOccurrence.SENTENCE_PRECED);
            if (taxInSentencePreceding.size() == 1) {
                finalTaxIds = taxInSentencePreceding;
            }
            if (taxInSentencePreceding.size() > 1) {
                this.cooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, restrictToCurrentScope ? SynonymSpeciesCooccurrenceService.Scope.SENTENCE : null, taxInSentencePreceding, parameterMap).stream().map(Pair::getLeft).forEach(finalTaxIds::add);
            }
            finalTaxIds = this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates(gm, finalTaxIds, this.scorer, parameterMap);
        }
        if (finalTaxIds.isEmpty() && parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_SINGULAR_FROM_SUCCEEDING_SAME_SENTENCE)) {
            Set<String> taxInSentenceSuccessive = this.getTaxIdsWithOccurrence(gm, GeneSpeciesOccurrence.SENTENCE_SUCCED);
            if (taxInSentenceSuccessive.size() == 1) {
                finalTaxIds = taxInSentenceSuccessive;
            }
            if (taxInSentenceSuccessive.size() > 1) {
                this.cooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, restrictToCurrentScope ? SynonymSpeciesCooccurrenceService.Scope.SENTENCE : null, taxInSentenceSuccessive, parameterMap).stream().map(Pair::getLeft).forEach(finalTaxIds::add);
            }
            finalTaxIds = this.geneCompatibleTaxFilter.checkForCompatibleTaxonomyCandidates(gm, finalTaxIds, this.scorer, parameterMap);
        }
        return finalTaxIds;
    }

    private Set<String> assignSingularInCompound(GeneMention gm, Set<String> finalTaxIds) {
        if (finalTaxIds.isEmpty()) {
            Set<String> taxInCompound = this.getTaxIdsWithOccurrence(gm, GeneSpeciesOccurrence.COMPOUND);
            if (taxInCompound.size() == 1) {
                finalTaxIds.add((String)taxInCompound.stream().findAny().get());
            }
            if (taxInCompound.size() > 1) {
                finalTaxIds = taxInCompound;
            }
            if (!finalTaxIds.isEmpty()) {
                gm.setTaxonomyCandidatesConjunctive(true);
            }
            if (gm.isAbbreviationLongForm()) {
                Set<String> longformTaxCandidates = finalTaxIds;
                Acronym acronym = gm.getGeneDocument().getOverlappingAcronymLongforms(gm.getOffsets()).stream().findAny().get().getAcronyms().get(0);
                gm.getGeneDocument().getOverlappingGenes(acronym.getOffsets()).forEach(g2 -> {
                    g2.setTaxonomyCandidates(longformTaxCandidates);
                    g2.setTaxonomyCandidatesConjunctive(true);
                    longformTaxCandidates.forEach(tax -> gm.getTaxonomyOccurrences().put((String)tax, GeneSpeciesOccurrence.COMPOUND));
                });
            }
        }
        return finalTaxIds;
    }

    private Set<String> getTaxIdsWithOccurrence(GeneMention gm, GeneSpeciesOccurrence occurrence) {
        Multimap<String, GeneSpeciesOccurrence> candidates = gm.getTaxonomyOccurrences();
        return candidates.keySet().stream().filter(tax -> candidates.get((String)tax).contains((Object)occurrence)).collect(Collectors.toSet());
    }
}

