/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.cooccurrence;

import de.julielab.geneexpbase.GeneExpException;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.SpeciesAssignmentException;
import de.julielab.speciesassignment.candidateretrieval.CandidateSetterForSpeciesTagger;
import de.julielab.speciesassignment.cooccurrence.SingularCooccurrenceAssignment;
import de.julielab.speciesassignment.cooccurrence.SingularToSetInference;
import de.julielab.speciesassignment.services.SpeciesAssignmentSentenceSmoothing;
import de.julielab.speciesassignment.services.SpeciesHintSetter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentSmoothing;
import java.util.Map;
import javax.inject.Inject;

public class CooccurrenceSpeciesAssigner
implements GeneSpeciesAssigner {
    private final CandidateSetterForSpeciesTagger candidateSetterForSpeciesTagger;
    private final SingularCooccurrenceAssignment singularAssignment;
    private final SingularToSetInference toSetInference;
    private final SpeciesAssignmentSmoothing assignmentSmoothing;

    @Inject
    public CooccurrenceSpeciesAssigner(CandidateSetterForSpeciesTagger candidateSetterForSpeciesTagger, SingularCooccurrenceAssignment singularAssignment, SpeciesAssignmentSentenceSmoothing speciesAssignmentSentenceSmoothing, SingularToSetInference singularToSetInference) {
        this.candidateSetterForSpeciesTagger = candidateSetterForSpeciesTagger;
        this.singularAssignment = singularAssignment;
        this.assignmentSmoothing = speciesAssignmentSentenceSmoothing;
        this.toSetInference = singularToSetInference;
    }

    @Override
    public void assign(GeneDocument document, Parameters parameterMap) throws SpeciesAssignmentException {
        try {
            if (!document.hasState(GeneDocument.State.SYNONYM_CANDIDATES_ASSIGNED)) {
                this.candidateSetterForSpeciesTagger.setCandidates(document, (Map<String, Object>)parameterMap);
            }
            this.singularAssignment.assignSingular(document, parameterMap);
            if (parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_INFERENCE_ENABLE)) {
                this.toSetInference.infer(document, parameterMap);
            }
            if (parameterMap.getString(Configuration.PARAM_SPECIES_ASSIGNMENT_SMOOTHING).equals("sentencewise")) {
                this.assignmentSmoothing.smooth(document, parameterMap);
            }
        }
        catch (GeneExpException e) {
            throw new SpeciesAssignmentException(e);
        }
    }

    @Override
    public void setSpeciesHints(GeneMention gm, Parameters parameterMap) {
        SpeciesHintSetter.setSpeciesHints(gm, parameterMap);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void assign(GeneDocument document) {
        throw new IllegalArgumentException("This class is currently not able to work without externally given parameters. Use assign(GeneDocument, Parameters) instead.");
    }
}

