/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.candidateretrieval;

import de.julielab.geneexpbase.candidateretrieval.CandidateCacheKey;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.genemodel.GeneName;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import spark.utils.StringUtils;

public class SimpleGeneNameQueryGenerator
extends QueryGenerator {
    @Override
    public Query generateQuery(CandidateCacheKey key) {
        GeneName geneName = key.getGeneName();
        BooleanQuery exactNormalizedNameQuery = new BooleanQuery.Builder().add(new TermQuery(new Term("names_exact", geneName.getNormalizedText())), BooleanClause.Occur.SHOULD).build();
        BooleanQuery exactLowerCaseNormalizedNameQuery = new BooleanQuery.Builder().add(new TermQuery(new Term("names_exact", geneName.getNormalizer().normalize(geneName.getText().toLowerCase()))), BooleanClause.Occur.SHOULD).build();
        Query normalizedTokenDisjunction = this.createDisjunctionQuery(geneName);
        BooleanQuery exactOrPartialNameQuery = new BooleanQuery.Builder().add(exactNormalizedNameQuery, BooleanClause.Occur.SHOULD).add(normalizedTokenDisjunction, BooleanClause.Occur.SHOULD).add(exactLowerCaseNormalizedNameQuery, BooleanClause.Occur.SHOULD).build();
        BooleanQuery.Builder finalQueryBuilder = new BooleanQuery.Builder();
        finalQueryBuilder.add(exactOrPartialNameQuery, BooleanClause.Occur.MUST);
        if (!StringUtils.isBlank(key.getTaxId())) {
            finalQueryBuilder.add(new TermQuery(new Term("tax_id", key.getTaxId())), BooleanClause.Occur.FILTER);
        }
        return finalQueryBuilder.build();
    }

    private Query createDisjunctionQuery(GeneName geneName) {
        String[] tokens = geneName.getNormalizedText().split("\\s+");
        BooleanQuery.Builder b = new BooleanQuery.Builder();
        for (String token : tokens) {
            b.add(new TermQuery(new Term("names_tokenized", token)), BooleanClause.Occur.SHOULD);
        }
        return b.build();
    }

    @Override
    public String getName() {
        return "SimpleGeneNames";
    }
}

