/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.candidateretrieval;

import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.GeneCandidateRetrievalException;
import de.julielab.geneexpbase.candidateretrieval.QueryGenerator;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.MentionMappingResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateSetterForSpeciesTagger {
    private static final Logger log = LoggerFactory.getLogger(CandidateSetterForSpeciesTagger.class);
    private final Configuration configuration;
    private final QueryGenerator queryGenerator;
    private final TermNormalizer normalizer;
    private final CandidateRetrieval candidateRetrieval;

    @Inject
    public CandidateSetterForSpeciesTagger(Configuration config, CandidateRetrieval candidateRetrieval, QueryGenerator queryGenerator, TermNormalizer normalizer) {
        this.configuration = config;
        this.candidateRetrieval = candidateRetrieval;
        this.queryGenerator = queryGenerator;
        this.normalizer = normalizer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public CandidateRetrieval getCandidateRetrieval() {
        return this.candidateRetrieval;
    }

    public void setCandidates(GeneDocument document, Map<String, Object> parameterMap) throws GeneCandidateRetrievalException {
        for (GeneMention gm : () -> document.getGenes().iterator()) {
            this.setCandidates(gm, parameterMap);
            this.setCandidates(gm.getParent(), parameterMap);
        }
        document.addState(GeneDocument.State.SYNONYM_CANDIDATES_ASSIGNED);
    }

    public void setCandidates(GeneMention gm, Map<String, Object> parameterMap) throws GeneCandidateRetrievalException {
        if (gm == null || gm.getMentionMappingResult() != null && gm.getMentionMappingResult().tax2originalCandidates != null) {
            return;
        }
        assert (gm.getDocumentContext() != null);
        assert (parameterMap != null);
        assert (gm.getGeneDocument().hasState(GeneDocument.State.SPECIES_CANDIDATES_ASSIGNED));
        gm.setNormalizer(this.normalizer);
        log.debug("Searching candidates for {}", (Object)gm.getText());
        MentionMappingResult mentionMappingResult = new MentionMappingResult();
        gm.setMentionMappingResult(mentionMappingResult);
        mentionMappingResult.mappedMention = gm;
        List<SynHit> candidates = this.candidateRetrieval.getCandidates(gm, Collections.emptySet(), this.queryGenerator);
        HashMap<String, List<SynHit>> tax2originalCandidates = new HashMap<String, List<SynHit>>();
        for (String taxId : gm.getTaxonomyOccurrences().keySet()) {
            List<SynHit> candidates4tax = this.candidateRetrieval.getCandidates(gm, Collections.emptySet(), Set.of(taxId), this.queryGenerator);
            tax2originalCandidates.put(taxId, candidates4tax);
        }
        mentionMappingResult.tax2originalCandidates = tax2originalCandidates;
        if (candidates != null && !candidates.isEmpty()) {
            mentionMappingResult.matchType = gm.hasExactCandidateMatch() ? MentionMappingResult.MatchType.EXACT : MentionMappingResult.MatchType.APPROX;
            SynHit resultHit = candidates.get(0);
            mentionMappingResult.setFinalRankedCandidates(resultHit.getTaxId(), List.of(resultHit));
        } else {
            mentionMappingResult.setFinalRankedCandidates("none", List.of(MentionMappingResult.REJECTION));
        }
    }
}

