/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment.apps;

import com.google.inject.Guice;
import com.google.inject.Injector;
import de.julielab.gene.candidateretrieval.ioc.IndexModule;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.data.DocumentLoader;
import de.julielab.geneexpbase.data.DocumentLoadingException;
import de.julielab.geneexpbase.data.DocumentSourceFileRegistry;
import de.julielab.geneexpbase.data.DocumentSourceFiles;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.ioc.BaseModule;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;

public class Deca2PubTatorConverter {
    public static void main(String[] args) throws IOException, DocumentLoadingException {
        Configuration configuration = new Configuration(Path.of("nni", "species_assignment.properties").toFile());
        Injector injector = Guice.createInjector(new BaseModule(configuration), new IndexModule(configuration));
        DocumentLoader documentLoader = injector.getInstance(DocumentLoader.class);
        DocumentSourceFiles decaSpeciesCorpus = DocumentSourceFileRegistry.decaSpeciesCorpus();
        Iterator docIt = documentLoader.getDocuments(decaSpeciesCorpus).iterator();
        while (docIt.hasNext()) {
            GeneDocument doc = (GeneDocument)docIt.next();
            System.out.println(doc.getPubTatorString());
        }
    }
}

