/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment;

import com.google.common.collect.Sets;
import de.julielab.gene.candidateretrieval.LuceneCandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.CandidateRetrieval;
import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.scoring.Scorer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class GeneCompatibleTaxFilter {
    private final CandidateRetrieval candidateRetrieval;

    @Inject
    public GeneCompatibleTaxFilter(CandidateRetrieval candidateRetrieval) {
        this.candidateRetrieval = candidateRetrieval;
    }

    public Set<String> checkForCompatibleTaxonomyCandidates(GeneMention gm, Set<String> offeredTaxIds, Scorer scorer, Parameters parameterMap) {
        List<SynHit> candidates = this.candidateRetrieval.getCandidates(gm, offeredTaxIds, LuceneCandidateRetrieval.GENE_RECORDS_CNF);
        double synhitGenMentionSimilaryThreshold = parameterMap.getDouble("species_assignment.singular.synonym_similarity_threshold");
        HashSet<String> foundTaxIds = new HashSet<String>();
        for (SynHit sh : candidates) {
            if (!(scorer.getScore(sh.getSynonym(), gm.getNormalizedText()) > synhitGenMentionSimilaryThreshold)) continue;
            foundTaxIds.add(sh.getTaxId());
        }
        return Sets.intersection(offeredTaxIds, foundTaxIds).stream().collect(Collectors.toSet());
    }
}

