/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment;

import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.speciesassignment.Configuration;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.candidateretrieval.CandidateSetterForSpeciesTagger;
import de.julielab.speciesassignment.cooccurrence.SingularToSetInference;
import de.julielab.speciesassignment.services.SpeciesAssignmentSentenceSmoothing;
import de.julielab.speciesassignment.services.SpeciesHintSetter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentFilter;
import de.julielab.speciesassignment.spi.SpeciesAssignmentSmoothing;
import de.julielab.speciesassignment.spi.SpeciesDocumentScoringService;
import de.julielab.speciesassignment.spi.SynonymSpeciesCooccurrenceService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.tuple.Pair;

public class GNormPlusGeneSpeciesExtendedAssigner
implements GeneSpeciesAssigner {
    private static final boolean EXPLAIN = false;
    private final SpeciesDocumentScoringService documentScoringService;
    private final SingularToSetInference toSetInference;
    private final CandidateSetterForSpeciesTagger candidateSetterForSpeciesTagger;
    private final SpeciesAssignmentFilter speciesAssignmentFilter;
    private final SpeciesAssignmentSmoothing assignmentSmoothing;
    private final SynonymSpeciesCooccurrenceService synonymSpeciesCooccurrenceService;

    @Inject
    public GNormPlusGeneSpeciesExtendedAssigner(SpeciesDocumentScoringService documentScoringService, SpeciesAssignmentSentenceSmoothing assignmentSmoothing, SynonymSpeciesCooccurrenceService synonymSpeciesCooccurrenceService, SingularToSetInference toSetInference, CandidateSetterForSpeciesTagger candidateSetterForSpeciesTagger, SpeciesAssignmentFilter speciesAssignmentFilter) {
        this.documentScoringService = documentScoringService;
        this.assignmentSmoothing = assignmentSmoothing;
        this.synonymSpeciesCooccurrenceService = synonymSpeciesCooccurrenceService;
        this.toSetInference = toSetInference;
        this.candidateSetterForSpeciesTagger = candidateSetterForSpeciesTagger;
        this.speciesAssignmentFilter = speciesAssignmentFilter;
    }

    @Override
    public void assign(GeneDocument document, Parameters parameterMap) {
        SpeciesHintSetter.setSpeciesMeshHeadings(document);
        this.speciesAssignmentFilter.filterSpeciesMentions(document);
        this.setSpeciesHints(parameterMap, document);
        this.speciesAssignmentFilter.filterAssignments(document);
        this.assignGNormPlusExtended(document, parameterMap);
        if (parameterMap.getBoolean(Configuration.PARAM_SYNONYM_APRIORI_INFERENCE_ENABLE)) {
            this.toSetInference.infer(document, parameterMap);
        }
        if (parameterMap.getString(Configuration.PARAM_SPECIES_ASSIGNMENT_SMOOTHING).equals("sentencewise")) {
            this.assignmentSmoothing.smooth(document, parameterMap);
        }
    }

    private void assignGNormPlusExtended(GeneDocument document, Parameters parameterMap) {
        document.expectState(EnumSet.of(GeneDocument.State.SPECIES_CANDIDATES_ASSIGNED));
        Map<String, Double> taxDocScores = this.documentScoringService.computeTaxDocScores(document, parameterMap);
        String highestGlobalScoringTax = null;
        for (GeneMention gm : document.getGenesIterable()) {
            Multimap<String, GeneSpeciesOccurrence> taxonomyCandidates = gm.getTaxonomyOccurrences();
            boolean taxIdAssigned = false;
            for (String string : taxonomyCandidates.keys()) {
                if (!taxonomyCandidates.get(string).contains((Object)GeneSpeciesOccurrence.SPECIES_PREFIX)) continue;
                gm.setTaxonomyIds(Collections.singletonList(string));
                taxIdAssigned = true;
            }
            boolean multiplIds = false;
            if (!taxIdAssigned) {
                for (String taxId : taxonomyCandidates.keySet()) {
                    if (!taxonomyCandidates.get(taxId).contains((Object)GeneSpeciesOccurrence.COMPOUND)) continue;
                    gm.addTaxonomyId(taxId);
                    if (gm.getTaxonomyIds().size() > 1) {
                        multiplIds = true;
                    }
                    taxIdAssigned = true;
                }
            }
            if (!taxIdAssigned) {
                for (String taxId : taxonomyCandidates.keySet()) {
                    if (!taxonomyCandidates.get(taxId).contains((Object)GeneSpeciesOccurrence.SENTENCE_NEAREST_PRECEDE)) continue;
                    gm.setTaxonomyIds(Collections.singletonList(taxId));
                    taxIdAssigned = true;
                }
            }
            if (!taxIdAssigned) {
                for (String taxId : taxonomyCandidates.keySet()) {
                    if (!taxonomyCandidates.get(taxId).contains((Object)GeneSpeciesOccurrence.SENTENCE_NEAREST_SUCCEED)) continue;
                    gm.setTaxonomyIds(Collections.singletonList(taxId));
                    taxIdAssigned = true;
                }
            }
            if (taxIdAssigned) continue;
            String string = parameterMap.getString(Configuration.SPECIES_ASSIGNMENT_FALLBACK_WHEN_NO_SINGULAR);
            if (string.equals("apriori_doclevel")) {
                if (highestGlobalScoringTax == null) {
                    double bestScore = 0.0;
                    for (String taxId3 : taxDocScores.keySet()) {
                        Double taxScore = taxDocScores.get(taxId3);
                        if (!(taxScore > bestScore)) continue;
                        highestGlobalScoringTax = taxId3;
                        bestScore = taxScore;
                    }
                }
                gm.setTaxonomyIds(Collections.singletonList(highestGlobalScoringTax));
            }
            if (!string.equals("apriori_synlevel")) continue;
            Set<Object> filterTax = document.getSpecies().getAllMentionCandidates().isEmpty() ? Collections.emptySet() : taxDocScores.keySet();
            Set<Pair<String, Double>> bestAPrioriTaxIdsForBestGeneCandidates = this.synonymSpeciesCooccurrenceService.getBestAPrioriTaxIdsForBestGeneCandidates(gm, null, filterTax, parameterMap);
            if (!bestAPrioriTaxIdsForBestGeneCandidates.isEmpty()) {
                Pair<String, Double> next = bestAPrioriTaxIdsForBestGeneCandidates.iterator().next();
                gm.setTaxonomyIds(List.of(next.getKey()));
                continue;
            }
            gm.setTaxonomyIds(List.of("9606"));
        }
        document.addState(GeneDocument.State.SPECIES_ASSIGNED_TO_GENES);
    }

    @Override
    public void setSpeciesHints(GeneMention gm, Parameters parameterMap) {
        SpeciesHintSetter.setSpeciesHints(gm, parameterMap);
    }

    private String explain(String tax, String explanation) {
        return String.format("%s:%s", explanation, tax);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void assign(GeneDocument document) {
        throw new IllegalArgumentException("This class is currently not able to work without externally given parameters. Use assign(GeneDocument, GeneMapperParameters) instead.");
    }
}

