/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.speciesassignment;

import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.configuration.Parameters;
import de.julielab.geneexpbase.genemodel.GeneDocument;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.geneexpbase.genemodel.GeneSpeciesOccurrence;
import de.julielab.speciesassignment.GeneSpeciesAssigner;
import de.julielab.speciesassignment.services.SpeciesHintSetter;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GNATSpeciesAssigner
implements GeneSpeciesAssigner {
    private static final Logger log = LoggerFactory.getLogger(GNATSpeciesAssigner.class);

    @Override
    public void assign(GeneDocument document, Parameters parameterMap) {
        for (GeneMention gm : () -> document.getGenes().iterator()) {
            Multimap<String, GeneSpeciesOccurrence> taxonomyCandidates = gm.getTaxonomyOccurrences();
            for (String taxId : taxonomyCandidates.keySet()) {
                HashSet<GeneSpeciesOccurrence> reliabilities = new HashSet<GeneSpeciesOccurrence>(taxonomyCandidates.get(taxId));
                Set<GNATSpeciesReliability> gnatReliabilities = this.translateToGnatReliability(reliabilities);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.COMPOUND);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.PHRASE);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.SENTENCE);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.PREVIOUS_SENTENCE);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.TITLE);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.FIRST);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.ANYWHERE);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, taxId, GNATSpeciesReliability.MESH);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, SpeciesHintSetter.getDefaultSpecies(), GNATSpeciesReliability.DEFAULT);
                this.setTaxIdIfReliabilitySuperseedsExisting(gm, gnatReliabilities, GNATSpeciesReliability.NONE.name(), GNATSpeciesReliability.NONE);
            }
        }
    }

    @Override
    public void setSpeciesHints(GeneMention gm, Parameters parameterMap) {
        SpeciesHintSetter.setSpeciesHints(gm, parameterMap);
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void assign(GeneDocument document) {
        throw new IllegalArgumentException("This class is currently not able to work without externally given parameters. Use assign(GeneDocument, GeneMapperParameters) instead.");
    }

    private boolean setTaxIdIfReliabilitySuperseedsExisting(GeneMention gm, Set<GNATSpeciesReliability> reliabilities, String taxId, GNATSpeciesReliability reliabilityToCheck) {
        if (reliabilities.contains((Object)reliabilityToCheck)) {
            GeneSpeciesOccurrence existingRelation = gm.getTaxonomyReliability();
            if (existingRelation != null) {
                GNATSpeciesReliability gnatSpeciesReliability = GNATSpeciesReliability.valueOf(existingRelation.name());
                if (reliabilityToCheck.compareTo(gnatSpeciesReliability) < 0) {
                    gm.setTaxonomyId(taxId);
                    gm.setTaxonomyReliability(GeneSpeciesOccurrence.valueOf(gnatSpeciesReliability.name()));
                    return true;
                }
            } else {
                gm.setTaxonomyId(taxId);
                gm.setTaxonomyReliability(GeneSpeciesOccurrence.valueOf(reliabilityToCheck.name()));
            }
        }
        return false;
    }

    private Set<GNATSpeciesReliability> translateToGnatReliability(Set<GeneSpeciesOccurrence> geneSpeciesAssigners) {
        HashSet<GNATSpeciesReliability> ret = new HashSet<GNATSpeciesReliability>();
        for (GeneSpeciesOccurrence relation : geneSpeciesAssigners) {
            if (relation == GeneSpeciesOccurrence.COMPOUND_PRECED || relation == GeneSpeciesOccurrence.COMPOUND_SUCCED) {
                ret.add(GNATSpeciesReliability.COMPOUND);
                continue;
            }
            try {
                ret.add(GNATSpeciesReliability.valueOf(relation.name()));
            }
            catch (IllegalArgumentException e) {
                log.debug("Skipping gene-species relation {} in translation to GNATSpeciesReliability because the relation is not known in the reliability enumeration", (Object)relation);
            }
        }
        return ret;
    }

    public static enum GNATSpeciesReliability {
        COMPOUND,
        PHRASE,
        SENTENCE,
        PREVIOUS_SENTENCE,
        TITLE,
        FIRST,
        ANYWHERE,
        MESH,
        DEFAULT,
        NONE;

    }
}

