/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.smac;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SmacParameterConfiguration {
    @JsonProperty(value="@pc-id")
    private int pcid;
    @JsonProperty(value="pc-settings")
    private Map<String, String> settings;
    @JsonProperty(value="pm-active-parameters")
    private List<String> activeParameters;
    @JsonProperty(value="pc-forbidden")
    private boolean forbidden;
    @JsonProperty(value="pc-default")
    private boolean defaultConfig;

    public int getPcid() {
        return this.pcid;
    }

    public void setPcid(int pcid) {
        this.pcid = pcid;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public Map<String, Object> getSettingsAsConfigurationMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : this.settings.keySet()) {
            String parameter = "-" + key;
            String value = this.settings.get(key);
            map.put(parameter, value);
        }
        return map;
    }

    public void setSettings(Map<String, String> settings) {
        this.settings = settings;
    }

    public List<String> getActiveParameters() {
        return this.activeParameters;
    }

    public void setActiveParameters(List<String> activeParameters) {
        this.activeParameters = activeParameters;
    }

    public boolean isForbidden() {
        return this.forbidden;
    }

    public void setForbidden(boolean forbidden) {
        this.forbidden = forbidden;
    }

    public boolean isDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(boolean defaultConfig) {
        this.defaultConfig = defaultConfig;
    }
}

