/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.smac;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.julielab.smac.SmacLiveRundata;
import de.julielab.smac.SmacLiveRundataEntry;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;

public class SmacLiveRundataReader {
    public SmacLiveRundata read(InputStream is) throws IOException {
        ObjectMapper om = new ObjectMapper();
        SmacLiveRundata smacLiveRundata = new SmacLiveRundata();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            int numRead;
            CharBuffer buf = CharBuffer.allocate(8192);
            StringBuilder sb = new StringBuilder();
            int numOpeningBraces = 0;
            boolean doRecord = false;
            int totalRead = 0;
            while ((numRead = br.read(buf)) != -1) {
                totalRead += numRead;
                for (int i = 0; i < numRead; ++i) {
                    if (buf.get(i) == '{') {
                        if (++numOpeningBraces == 1) {
                            doRecord = true;
                        }
                    } else if (buf.get(i) == '}') {
                        if (numOpeningBraces == 1) {
                            sb.append(buf.get(i));
                            String json = sb.toString();
                            if (json.contains("@rc-id")) {
                                SmacLiveRundataEntry entry = om.readValue(json, SmacLiveRundataEntry.class);
                                smacLiveRundata.add(entry);
                            }
                            sb.delete(0, sb.length());
                            doRecord = false;
                        }
                        --numOpeningBraces;
                    }
                    if (!doRecord) continue;
                    sb.append(buf.get(i));
                }
                buf.clear();
            }
        }
        return smacLiveRundata;
    }

    public SmacLiveRundata read(File livedataFile) throws IOException {
        return this.read(new BufferedInputStream(new FileInputStream(livedataFile)));
    }
}

