/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.smac;

import de.julielab.smac.FullyEvaluatedConfiguration;
import de.julielab.smac.SmacLiveRundataEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class SmacLiveRundata
extends ArrayList<SmacLiveRundataEntry> {
    public SmacLiveRundataEntry getEntryWithBestScore() {
        SmacLiveRundataEntry bestEntry = null;
        for (SmacLiveRundataEntry entry : this) {
            if (bestEntry != null && !(bestEntry.getrQuality() > entry.getrQuality())) continue;
            bestEntry = entry;
        }
        return bestEntry;
    }

    public List<SmacLiveRundataEntry> getEntriesWithBestScore(int n) {
        ArrayList<SmacLiveRundataEntry> entries = new ArrayList<SmacLiveRundataEntry>(this);
        Collections.sort(entries, Comparator.comparingDouble(SmacLiveRundataEntry::getrQuality).reversed());
        return entries.subList(Math.max(entries.size() - n, 0), entries.size());
    }

    public List<FullyEvaluatedConfiguration> getBestFullyEvaluatedConfigurations(int n) {
        Map<Integer, List<SmacLiveRundataEntry>> pcid2runs = this.stream().collect(Collectors.groupingBy(e -> e.getRunInfo().getConfiguration().getPcid()));
        OptionalInt maxRunsPerConfigOpt = pcid2runs.keySet().stream().mapToInt(pcid -> ((List)pcid2runs.get(pcid)).size()).max();
        ArrayList<FullyEvaluatedConfiguration> fullyEvaluatedConfigurations = new ArrayList<FullyEvaluatedConfiguration>();
        if (maxRunsPerConfigOpt.isPresent()) {
            int maxRunsPerConfig = maxRunsPerConfigOpt.getAsInt();
            for (List<SmacLiveRundataEntry> entries : pcid2runs.values()) {
                if (entries.size() != maxRunsPerConfig) continue;
                FullyEvaluatedConfiguration evaluatedConfiguration = new FullyEvaluatedConfiguration(entries);
                evaluatedConfiguration.calculateAvgQuality();
                fullyEvaluatedConfigurations.add(evaluatedConfiguration);
            }
        }
        Collections.sort(fullyEvaluatedConfigurations, Comparator.comparingDouble(FullyEvaluatedConfiguration::getAvgQuality).reversed());
        return fullyEvaluatedConfigurations.subList(Math.max(fullyEvaluatedConfigurations.size() - n, 0), fullyEvaluatedConfigurations.size());
    }
}

