/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.smac;

import de.julielab.smac.SmacLiveRundataEntry;
import de.julielab.smac.SmacParameterConfiguration;
import java.util.ArrayList;
import java.util.List;

public class FullyEvaluatedConfiguration
extends ArrayList<SmacLiveRundataEntry> {
    private int pcid;
    private double avgQuality = Double.MAX_VALUE;

    public FullyEvaluatedConfiguration(List<SmacLiveRundataEntry> entries) {
        super(entries);
        if (!this.isEmpty()) {
            this.pcid = ((SmacLiveRundataEntry)this.get(0)).getRunInfo().getConfiguration().getPcid();
        }
    }

    public SmacParameterConfiguration getConfiguration() {
        if (!this.isEmpty()) {
            return ((SmacLiveRundataEntry)this.get(0)).getRunInfo().getConfiguration();
        }
        return null;
    }

    public double getAvgQuality() {
        if (this.avgQuality == Double.MAX_VALUE) {
            throw new IllegalStateException("The average quality has not yet been calculated. Call 'calculateAvgQuality' first.");
        }
        return this.avgQuality;
    }

    public void calculateAvgQuality() {
        this.stream().mapToDouble(SmacLiveRundataEntry::getrQuality).average().ifPresent(avg -> {
            this.avgQuality = avg;
        });
    }

    public int getPcid() {
        return this.pcid;
    }

    public void setPcid(int pcid) {
        this.pcid = pcid;
    }
}

