/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.smac;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Route;

public class EvaluateConfigurationRoute
implements Route {
    private static final Logger log = LoggerFactory.getLogger(EvaluateConfigurationRoute.class);

    @Override
    public Object handle(Request req, Response res) throws Exception {
        if (req.queryParams().contains("SHUTDOWN")) {
            log.info("Committing all caches is done, server can be shutdown.");
            return 0;
        }
        Set<String> queryParams = req.queryParams();
        String instanceName = null;
        String instanceInfo = null;
        int cutoffTime = 0;
        int cutoffLength = 0;
        int seed = 0;
        Object indexSuffix = null;
        Object metricsToReturn = null;
        boolean metricsPerTopic = false;
        ArrayList<String> parameters = new ArrayList<String>(queryParams.size());
        parameters.addAll(Arrays.asList(null, null, null, null, null));
        Iterator<String> iterator = queryParams.iterator();
        block16: while (iterator.hasNext()) {
            String queryParam;
            switch (queryParam = iterator.next()) {
                case "instance": {
                    instanceName = req.queryParams(queryParam);
                    continue block16;
                }
                case "instance_info": {
                    instanceInfo = req.queryParams(queryParam);
                    continue block16;
                }
                case "cutoff_time": {
                    cutoffTime = (int)Math.round(Double.valueOf(req.queryParams(queryParam)));
                    continue block16;
                }
                case "cutoff_length": {
                    cutoffLength = (int)Math.round(Double.valueOf(req.queryParams(queryParam)));
                    continue block16;
                }
                case "seed": {
                    seed = Integer.valueOf(req.queryParams(queryParam));
                    continue block16;
                }
            }
            parameters.add("-" + queryParam);
            parameters.add(req.queryParams(queryParam));
        }
        Map<String, Object> parameterMap = this.parseParameters(parameters);
        String score = this.calculateScore(instanceName, parameterMap, seed);
        return score;
    }

    protected Map<String, Object> parseParameters(List<String> parameters) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < parameters.size(); ++i) {
            String s2 = parameters.get(i);
            if (i % 2 != 1) continue;
            map.put(parameters.get(i - 1), s2);
        }
        return map;
    }

    protected String calculateScore(String instance, Map<String, Object> parameterMap, int seed) {
        return "-0";
    }
}

