/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import de.julielab.costosys.cli.TableNotFoundException;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.CoStoSysSQLRuntimeException;
import de.julielab.costosys.dbconnection.util.TableSchemaMismatchException;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiReaderUtils {
    private static final Logger log = LoggerFactory.getLogger(XmiReaderUtils.class);

    public static void checkXmiTableSchema(DataBaseConnector dbc, String tableName, FieldConfig xmiDocumentTableSchema, String componentName) throws ResourceInitializationException {
        String dataTable = null;
        try {
            dataTable = dbc.getNextOrThisDataTable(tableName);
            dbc.checkTableHasSchemaColumns(dataTable, xmiDocumentTableSchema.getName());
        }
        catch (TableNotFoundException | CoStoSysSQLRuntimeException e) {
            throw new ResourceInitializationException(e);
        }
        catch (TableSchemaMismatchException e) {
            try {
                String error = dbc.isDataTable(tableName) ? String.format("The table \"%s\" specified to read for the %s does not match the XMI text storage data schema. Either the DoGzip parameter does not match the setting that was used for the XMI DB Consumer or the specified table is not an XMI table.", tableName, componentName) : String.format("The subset table \"%s\" specified to read for the %s references the data table \"%s\". This data table does not match the XMI text storage data schema. Either the DoGzip parameter does not match the setting that was used for the XMI DB Consumer or the specified table is not an XMI table.", tableName, componentName, dataTable);
                log.error(error);
                throw new ResourceInitializationException(new TableSchemaMismatchException(error, e));
            }
            catch (CoStoSysSQLRuntimeException e1) {
                throw new ResourceInitializationException(e1);
            }
        }
    }
}

