/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import de.julielab.costosys.cli.TableNotFoundException;
import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBMultiplierReader;
import de.julielab.jcore.reader.xmi.XmiReaderUtils;
import de.julielab.jcore.types.casmultiplier.RowBatch;
import de.julielab.jcore.utility.JCoReTools;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe XMI Database Multiplier Reader", description="This is an extension of the DBMultiplierReader to handle JeDIS XMI annotation module data.")
public class XmiDBMultiplierReader
extends DBMultiplierReader {
    public static final String PARAM_STORE_XMI_ID = "StoreMaxXmiId";
    public static final String PARAM_READS_BASE_DOCUMENT = "ReadsBaseDocument";
    public static final String PARAM_INCREASED_ATTRIBUTE_SIZE = "IncreasedAttributeSize";
    public static final String PARAM_XERCES_ATTRIBUTE_BUFFER_SIZE = "XercesAttributeBufferSize";
    public static final String PARAM_ANNOTATIONS_TO_LOAD = "AnnotationsToLoad";
    public static final String PARAM_XMI_META_SCHEMA = "XmiMetaTablesSchema";
    private static final Logger log = LoggerFactory.getLogger(XmiDBMultiplierReader.class);
    @ConfigurationParameter(name="AnnotationsToLoad", mandatory=false, description="An array of qualified UIMA type names. The provided names will be converted to database table column names in an equivalent manner as the XMIDBWriter does when storing the annotations. Thus, by default the columns of the XMI table holding annotation module information are named by lowercased UIMA type name where dots are replaced by underscores.. This can be overwritten by appending '<schema>:' to a table name. The given type names will be converted to valid Postgres columns names by replacing dots with underscores and the colon will be converted to the dollar character. From the resolved columns, annotation modules in segmented XMI format are read where an annotation module contains all annotation instances of a specific type in a specific document. All annotation modules read this way are merged with the base document, resulting in valid XMI data which is then deserialized into the CAS.")
    protected String[] qualifiedAnnotationColumnNames;
    @ConfigurationParameter(name="ReadsBaseDocument", description="Indicates if this reader reads segmented annotation data. If set to false, the XMI data is expected to represent complete annotated documents. If it is set to true, a segmented annotation graph is expected and the table given with the 'Table' parameter will contain the document text together with some basic annotations. What exactly is stored in which manner is determined by the jcore-xmi-db-consumer used to write the data into the database.")
    private Boolean readsBaseDocument;
    @ConfigurationParameter(name="StoreMaxXmiId", mandatory=false, description="This parameter is required to be set to true, if this reader is contained in a pipeline that also contains a jcore-xmi-db-writer andthe writer will segment the CAS annotation graph and store only parts of it. Then, it is important to keep track of the free XMI element IDs that may be assigned to new annotation elements to avoid ID clashes when assembling an XMI document from separately stored annotation graph segments.")
    private Boolean storeMaxXmiId;
    @ConfigurationParameter(name="IncreasedAttributeSize", mandatory=false, description="Maxmimum XML attribute size in bytes. Since the CAS document text is stored as an XMI attribute, it might happen for large documents that there is an error because the maximum attribute size is exceeded. This parameter allows to specify the maxmimum  attribute size in order to avoid such errors. Should only be set if required.")
    private int maxXmlAttributeSize;
    @ConfigurationParameter(name="XercesAttributeBufferSize", mandatory=false, description="Initial XML parser buffer size in bytes. For large documents, it can happen that XMI parsing is extremely slow. By employing monitoring tools like the jconsole or (j)visualvm, the hot spots of work can be identified. If one of those is the XML attribute buffer resizing, this parameter should be set to a size that makes buffer resizing unnecessary.")
    private int xercesAttributeBufferSize;
    @ConfigurationParameter(name="XmiMetaTablesSchema", mandatory=false, defaultValue={"public"}, description="Each XMI file defines a number of XML namespaces according to the types used in the document. Those namespaces are stored in a table named '_xmi_namespaces' when splitting annotations in annotation modules by the XMI DB writer. This parameter allows to specify in which Postgres schema this table should be looked for. Also, the table listing the annotation tables is stored in this Postgres schema. Defaults to 'public'.")
    private String xmiMetaSchema;
    private boolean doGzip;
    private String[] additionalTableNames;
    private boolean useBinaryFormat;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        this.qualifiedAnnotationColumnNames = Optional.ofNullable((String[])context.getConfigParameterValue(PARAM_ANNOTATIONS_TO_LOAD)).orElse(new String[0]);
        this.adaptReaderConfigurationForXmiData();
        super.initialize(context);
        this.readsBaseDocument = (Boolean)(context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT));
        this.storeMaxXmiId = (Boolean)(context.getConfigParameterValue(PARAM_STORE_XMI_ID) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_STORE_XMI_ID));
        this.readsBaseDocument = (Boolean)(context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT));
        Optional.ofNullable((Integer)context.getConfigParameterValue(PARAM_INCREASED_ATTRIBUTE_SIZE)).ifPresent(v -> {
            this.maxXmlAttributeSize = v;
        });
        Optional.ofNullable((Integer)context.getConfigParameterValue(PARAM_XERCES_ATTRIBUTE_BUFFER_SIZE)).ifPresent(v -> {
            this.xercesAttributeBufferSize = v;
        });
        this.xmiMetaSchema = Optional.ofNullable((String)context.getConfigParameterValue(PARAM_XMI_META_SCHEMA)).orElse("public");
        super.initialize(context);
    }

    @Override
    public void getNext(JCas jCas) throws CollectionException, IOException {
        try {
            super.getNext(jCas);
            RowBatch rowBatch = JCasUtil.selectSingle(jCas, RowBatch.class);
            rowBatch.setReadsBaseXmiDocument(this.readsBaseDocument);
            if (this.qualifiedAnnotationColumnNames != null) {
                rowBatch.setXmiAnnotationModuleNames(JCoReTools.newStringArray(jCas, this.qualifiedAnnotationColumnNames));
            }
            rowBatch.setStoreMaxXmiId(this.storeMaxXmiId);
            rowBatch.setIncreasedAttributeSize(this.maxXmlAttributeSize);
            rowBatch.setXercesAttributeBufferSize(this.xercesAttributeBufferSize);
            rowBatch.setXmiMetaTablesPostgresSchema(this.xmiMetaSchema);
        }
        catch (Throwable throwable) {
            log.error("Exception occurred while trying to get the next document", throwable);
            throw throwable;
        }
    }

    private void adaptReaderConfigurationForXmiData() throws ResourceInitializationException {
        this.costosysConfig = (String)this.getConfigParameterValue("CostosysConfigFile");
        try {
            this.dbc = new DataBaseConnector(this.costosysConfig);
            if (this.dbc.getMaxConnections() < 3) {
                this.dbc.setMaxConnections(3);
            }
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException(e);
        }
        try (CoStoSysConnection ignored = this.dbc.obtainOrReserveConnection();){
            List<Map<String, String>> primaryKeyFields = this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList());
            String table = (String)this.getConfigParameterValue("Table");
            if (!this.dbc.tableExists(table)) {
                throw new ResourceInitializationException(new TableNotFoundException("Table " + table + " does not exist in database " + this.dbc.getDbURL()));
            }
            if (((Boolean)this.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT)).booleanValue()) {
                this.determineDataFormat(table);
                ArrayList<Map<String, String>> xmiAnnotationColumnsDefinitions = new ArrayList<Map<String, String>>();
                for (String qualifiedAnnotation : this.qualifiedAnnotationColumnNames) {
                    String columnName = qualifiedAnnotation.toLowerCase().replace('.', '_').replace(':', '$');
                    Map<String, String> field = FieldConfig.createField("name", columnName, "gzip", String.valueOf(this.doGzip), "retrieve", "true", "type", this.doGzip || this.useBinaryFormat ? "bytea" : "xml");
                    xmiAnnotationColumnsDefinitions.add(field);
                }
                FieldConfig xmiDocumentTableSchema = this.dbc.addXmiTextFieldConfiguration(primaryKeyFields, xmiAnnotationColumnsDefinitions, this.doGzip);
                this.dbc.setActiveTableSchema(xmiDocumentTableSchema.getName());
                XmiReaderUtils.checkXmiTableSchema(this.dbc, this.tableName, xmiDocumentTableSchema, this.getMetaData().getName());
            } else {
                this.determineDataFormat(table);
                FieldConfig xmiDocumentFieldConfiguration = this.dbc.addXmiDocumentFieldConfiguration(primaryKeyFields, this.doGzip);
                this.dbc.setActiveTableSchema(xmiDocumentFieldConfiguration.getName());
            }
        }
    }

    private void determineDataFormat(String table) throws ResourceInitializationException {
        this.doGzip = true;
        this.useBinaryFormat = true;
        this.dataTable = this.dbc.getNextOrThisDataTable(table);
        log.debug("Fetching a single row from data table {} in order to determine whether data is in GZIP format", (Object)this.dataTable);
        try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
            ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT %s FROM %s LIMIT 1", "base_document", this.dataTable));
            while (rs.next()) {
                byte[] xmiData = rs.getBytes("base_document");
                try (GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(xmiData));){
                    byte[] firstTwoBytes = new byte[2];
                    gzis.read(firstTwoBytes);
                    this.checkForJeDISBinaryFormat(firstTwoBytes);
                }
                catch (IOException e) {
                    log.debug("Attempt to read XMI data in GZIP format failed. Assuming non-gzipped XMI data.");
                    this.doGzip = false;
                    this.checkForJeDISBinaryFormat(xmiData);
                }
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("does not exist")) {
                log.error("An exception occurred when trying to read the xmi column of the data table \"{}\". It seems the table does not contain XMI data and this is invalid to use with this reader.", (Object)this.dataTable);
            }
            throw new ResourceInitializationException(e);
        }
    }

    private void checkForJeDISBinaryFormat(byte[] firstTwoBytes) {
        short header = (short)(firstTwoBytes[0] << 8 | 0xFF & firstTwoBytes[1]);
        if (header != 24981) {
            this.useBinaryFormat = false;
            log.debug("Is data encoded in JeDIS binary format: false");
        } else {
            log.debug("Is data encoded in JeDIS binary format: true");
        }
    }
}

