/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBMultiplier;
import de.julielab.jcore.reader.db.DBReader;
import de.julielab.jcore.reader.xmi.CasPopulationException;
import de.julielab.jcore.reader.xmi.CasPopulator;
import de.julielab.jcore.reader.xmi.Initializable;
import de.julielab.jcore.reader.xmi.Initializer;
import de.julielab.jcore.reader.xmi.XmiReaderUtils;
import de.julielab.jcore.types.casmultiplier.RowBatch;
import de.julielab.jcore.types.pubmed.Header;
import de.julielab.jcore.utility.JCoReTools;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmiDBMultiplier
extends DBMultiplier
implements Initializable {
    public static final String PARAM_LOG_FINAL_XMI = "LogFinalXmi";
    public static final String PARAM_TRUNCATE_AT_SIZE = "TruncateAtSize";
    private static final Logger log = LoggerFactory.getLogger(XmiDBMultiplier.class);
    @ConfigurationParameter(name="LogFinalXmi", mandatory=false, defaultValue={"false"}, description="For debugging purposes. If set to true, before parsing the final XMI data assembled from the annotation modules, it is printed to console.")
    private boolean logFinalXmi;
    @ConfigurationParameter(name="TruncateAtSize", mandatory=false, description="Specify size in bytes of the XMI sofa string, i.e. the document text. If the text surpasses that size, the document is not populated from XMI but given some placeholder information. This can be necessary when large documents cannot be handled by subsequent components in the pipeline.")
    private int truncationSize;
    private Initializer initializer;
    private CasPopulator casPopulator;
    private String[] xmiModuleAnnotationNames;
    private boolean doGzip;
    private boolean useBinaryFormat;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.logFinalXmi = Optional.ofNullable((Boolean)aContext.getConfigParameterValue(PARAM_LOG_FINAL_XMI)).orElse(false);
        this.truncationSize = Optional.ofNullable((Integer)aContext.getConfigParameterValue(PARAM_TRUNCATE_AT_SIZE)).orElse(0);
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        log.trace("Incoming jCas instance: " + aJCas);
        boolean initDone = this.initialized;
        RowBatch rowBatch = null;
        if (!initDone) {
            try {
                rowBatch = JCasUtil.selectSingle(aJCas, RowBatch.class);
                this.adaptReaderConfigurationForXmiData(rowBatch);
                if (rowBatch.getXmiAnnotationModuleNames() != null) {
                    this.xmiModuleAnnotationNames = rowBatch.getXmiAnnotationModuleNames().toStringArray();
                }
            }
            catch (ResourceInitializationException e) {
                throw new AnalysisEngineProcessException(e);
            }
        }
        try {
            super.process(aJCas);
            if (this.initializer == null) {
                log.debug("Initializing");
                this.initializer = new Initializer(this, this.dbc, this.xmiModuleAnnotationNames, this.xmiModuleAnnotationNames.length > 0, this.useBinaryFormat);
                this.initializer.initialize(rowBatch);
                this.initializer.setLogFinalXmi(this.logFinalXmi);
                this.casPopulator = new CasPopulator(this.dataTable, this.initializer, this.readDataTable, this.tableName);
            }
        }
        catch (Throwable t) {
            log.error("Error when initializing: ", t);
            throw new AnalysisEngineProcessException(t);
        }
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        JCas jCas;
        block5: {
            jCas = this.getEmptyJCas();
            try {
                if (!this.documentDataIterator.hasNext()) break block5;
                log.trace("Returning next CAS");
                try {
                    this.initializer.initializeAnnotationTableNames(jCas);
                }
                catch (ResourceInitializationException e) {
                    throw new AnalysisEngineProcessException(e);
                }
                this.populateCas(jCas);
            }
            catch (Throwable throwable) {
                log.error("Error while reading document from the database. Releasing the CAS. ", throwable);
                jCas.release();
                throw new AnalysisEngineProcessException(throwable);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Outgoing multiplier jCas instance: {}", (Object)jCas);
            log.trace("Returning CAS containing document {}", (Object)JCoReTools.getDocId(jCas));
        }
        return jCas;
    }

    private void populateCas(JCas jCas) throws AnalysisEngineProcessException {
        if (this.casPopulator == null) {
            throw new AnalysisEngineProcessException(new IllegalStateException("Initialization of the component was not finished. See previous errors to learn the reason. Cannot continue."));
        }
        try {
            byte[][] data = (byte[][])this.documentDataIterator.next();
            int pkSize = (int)this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().count();
            if (log.isTraceEnabled()) {
                ArrayList<CallSite> l = new ArrayList<CallSite>();
                for (int i = pkSize; i < data.length; ++i) {
                    if (data[i] == null) continue;
                    int length = data[i].length;
                    double lengthInMb = (double)length / 1024.0 / 1024.0;
                    l.add((CallSite)((Object)("col" + i + ":" + lengthInMb + "MB")));
                }
                log.trace("Populating CAS for document ID {} with column data of sizes {}", (Object)new String(data[0]), (Object)String.join((CharSequence)",", l));
            }
            boolean truncate = false;
            if (this.truncationSize > 0 && data[pkSize].length > this.truncationSize) {
                truncate = true;
            }
            if (data != null && !truncate) {
                this.casPopulator.populateCas(data, jCas);
            } else if (truncate) {
                jCas.setDocumentText("This document was truncated due to exceedingly long text contents.");
                ArrayList<String> pkElements = new ArrayList<String>();
                for (int i = 0; i < pkSize; ++i) {
                    pkElements.add(new String(data[i], StandardCharsets.UTF_8));
                }
                Header header = new Header(jCas);
                header.setDocId(pkElements.stream().collect(Collectors.joining(",")));
                header.addToIndexes();
                CasPopulator.storeMaxXmiIdAndSofaMappings(jCas, data, this.initializer.getStoreMaxXmiId());
                DBReader.setDBProcessingMetaData(this.dbc, this.readDataTable, this.tableName, data, jCas);
                log.debug("Truncating document with ID {} due to its text size of {} bytes which is greater than the given threshold of {} bytes.", pkElements, data[pkSize].length, this.truncationSize);
            }
        }
        catch (CasPopulationException e) {
            log.error("Exception while populating CAS", e);
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public String[] getAdditionalTableNames() {
        return new String[0];
    }

    @Override
    public String[] getTables() {
        return this.tables;
    }

    private void adaptReaderConfigurationForXmiData(RowBatch rowBatch) throws ResourceInitializationException {
        String costosysConfig = rowBatch.getCostosysConfiguration();
        try {
            this.dbc = new DataBaseConnector(costosysConfig);
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException(e);
        }
        try (CoStoSysConnection ignored = this.dbc.obtainOrReserveConnection();){
            List<Map<String, String>> primaryKeyFields = this.dbc.getActiveTableFieldConfiguration().getPrimaryKeyFields().collect(Collectors.toList());
            if (rowBatch.getReadsBaseXmiDocument()) {
                this.tableName = rowBatch.getTableName();
                this.dataTable = rowBatch.getTables(0);
                this.determineDataFormat(this.dataTable);
                ArrayList<Map<String, String>> xmiAnnotationColumnsDefinitions = new ArrayList<Map<String, String>>();
                for (String qualifiedAnnotation : rowBatch.getXmiAnnotationModuleNames()) {
                    String columnName = qualifiedAnnotation.toLowerCase().replace('.', '_').replace(':', '$');
                    Map<String, String> field = FieldConfig.createField("name", columnName, "gzip", String.valueOf(this.doGzip), "retrieve", "true", "type", this.doGzip || this.useBinaryFormat ? "bytea" : "xml");
                    xmiAnnotationColumnsDefinitions.add(field);
                }
                FieldConfig xmiDocumentTableSchema = this.dbc.addXmiTextFieldConfiguration(primaryKeyFields, xmiAnnotationColumnsDefinitions, this.doGzip);
                this.dbc.setActiveTableSchema(xmiDocumentTableSchema.getName());
                String[] tables = rowBatch.getTables().toStringArray();
                String[] additionalTables = Arrays.copyOfRange(tables, 1, tables.length);
                if (additionalTables != null && additionalTables.length > 0) {
                    FieldConfig xmiAnnotationTableSchema = this.dbc.addXmiAnnotationFieldConfiguration(primaryKeyFields, this.doGzip);
                    rowBatch.setTableSchemas(1, xmiAnnotationTableSchema.getName());
                }
                XmiReaderUtils.checkXmiTableSchema(this.dbc, this.dataTable, xmiDocumentTableSchema, this.getClass().getSimpleName());
            } else {
                String table = rowBatch.getTables(0);
                this.determineDataFormat(table);
                FieldConfig xmiDocumentFieldConfiguration = this.dbc.addXmiDocumentFieldConfiguration(primaryKeyFields, this.doGzip);
                this.dbc.setActiveTableSchema(xmiDocumentFieldConfiguration.getName());
            }
        }
    }

    private void determineDataFormat(String table) throws ResourceInitializationException {
        this.doGzip = true;
        this.useBinaryFormat = true;
        this.dataTable = this.dbc.getNextOrThisDataTable(table);
        log.debug("Fetching a single row from data table {} in order to determine whether data is in GZIP format", (Object)this.dataTable);
        try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
            ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT %s FROM %s LIMIT 1", "base_document", this.dataTable));
            while (rs.next()) {
                byte[] xmiData = rs.getBytes("base_document");
                try (GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(xmiData));){
                    byte[] firstTwoBytes = new byte[2];
                    gzis.read(firstTwoBytes);
                    this.checkForJeDISBinaryFormat(firstTwoBytes);
                }
                catch (IOException e) {
                    log.debug("Attempt to read XMI data in GZIP format failed. Assuming non-gzipped XMI data. Expected exception:", e);
                    this.doGzip = false;
                    this.checkForJeDISBinaryFormat(xmiData);
                }
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("does not exist")) {
                log.error("An exception occurred when trying to read the xmi column of the data table \"{}\". It seems the table does not contain XMI data and this is invalid to use with this reader.", (Object)this.dataTable);
            }
            throw new ResourceInitializationException(e);
        }
    }

    private void checkForJeDISBinaryFormat(byte[] firstTwoBytes) {
        short header = (short)(firstTwoBytes[0] << 8 | 0xFF & firstTwoBytes[1]);
        if (header != 24981) {
            this.useBinaryFormat = false;
            log.debug("Is data encoded in JeDIS binary format: false");
        } else {
            log.debug("Is data encoded in JeDIS binary format: true");
        }
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        log.info("Closing database connector.");
        this.dbc.close();
    }
}

