/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import de.julielab.costosys.dbconnection.CoStoSysConnection;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.xmi.Initializable;
import de.julielab.jcore.types.casmultiplier.RowBatch;
import de.julielab.xml.XmiBuilder;
import de.julielab.xml.binary.BinaryXmiBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializer {
    public static final String PARAM_STORE_XMI_ID = "StoreMaxXmiId";
    public static final String PARAM_LOG_FINAL_XMI = "LogFinalXmi";
    public static final String PARAM_READS_BASE_DOCUMENT = "ReadsBaseDocument";
    public static final String PARAM_INCREASED_ATTRIBUTE_SIZE = "IncreasedAttributeSize";
    public static final String PARAM_XERCES_ATTRIBUTE_BUFFER_SIZE = "XercesAttributeBufferSize";
    public static final String PARAM_XMI_META_SCHEMA = "XmiMetaTablesSchema";
    public static final String PARAM_ANNOTATIONS_TO_LOAD = "AnnotationsToLoad";
    private static final Logger log = LoggerFactory.getLogger(Initializer.class);
    private final String[] unqualifiedAnnotationModuleNames;
    private final boolean joinTables;
    private boolean useBinaryFormat;
    private Map<Integer, String> reverseBinaryMapping;
    private Map<String, Boolean> featuresToMapBinary;
    private Boolean storeMaxXmiId;
    private int maxXmlAttributeSize;
    private int xercesAttributeBufferSize;
    private Boolean readsBaseDocument;
    private boolean initializationComplete;
    private int numAdditionalTables;
    private int numDataRetrievedDataFields;
    private XmiBuilder builder;
    private BinaryXmiBuilder binaryBuilder;
    private Boolean logFinalXmi;
    private DataBaseConnector dbc;
    private Initializable initializable;
    private String xmiMetaSchema;

    public Initializer(Initializable initializable, DataBaseConnector dbc, String[] unqualifiedAnnotationModuleNames, boolean joinTables, boolean useBinaryFormat) {
        this.initializable = initializable;
        this.dbc = dbc;
        this.unqualifiedAnnotationModuleNames = unqualifiedAnnotationModuleNames != null ? (String[])Stream.of(unqualifiedAnnotationModuleNames).map(name -> name.split(":")).map(split -> ((String[])split).length == 1 ? split[0] : split[1]).toArray(String[]::new) : null;
        this.joinTables = joinTables;
        this.useBinaryFormat = useBinaryFormat;
    }

    public XmiBuilder getXmiBuilder() {
        return this.builder;
    }

    public String[] getUnqualifiedAnnotationModuleNames() {
        return this.unqualifiedAnnotationModuleNames;
    }

    public boolean isJoinTables() {
        return this.joinTables;
    }

    public void initialize(UimaContext context) {
        this.storeMaxXmiId = (Boolean)(context.getConfigParameterValue(PARAM_STORE_XMI_ID) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_STORE_XMI_ID));
        this.logFinalXmi = (Boolean)(context.getConfigParameterValue(PARAM_LOG_FINAL_XMI) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_LOG_FINAL_XMI));
        this.readsBaseDocument = (Boolean)(context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT) == null ? Boolean.valueOf(false) : context.getConfigParameterValue(PARAM_READS_BASE_DOCUMENT));
        Optional.ofNullable((Integer)context.getConfigParameterValue(PARAM_INCREASED_ATTRIBUTE_SIZE)).ifPresent(v -> {
            this.maxXmlAttributeSize = v;
        });
        Optional.ofNullable((Integer)context.getConfigParameterValue(PARAM_XERCES_ATTRIBUTE_BUFFER_SIZE)).ifPresent(v -> {
            this.xercesAttributeBufferSize = v;
        });
        this.xmiMetaSchema = Optional.ofNullable((String)context.getConfigParameterValue(PARAM_XMI_META_SCHEMA)).orElse("public");
        this.initAfterParameterReading();
    }

    public void initialize(RowBatch rowBatch) {
        this.storeMaxXmiId = rowBatch.getStoreMaxXmiId();
        this.logFinalXmi = false;
        this.readsBaseDocument = rowBatch.getReadsBaseXmiDocument();
        this.maxXmlAttributeSize = rowBatch.getIncreasedAttributeSize();
        this.xercesAttributeBufferSize = rowBatch.getXercesAttributeBufferSize();
        this.xmiMetaSchema = rowBatch.getXmiMetaTablesPostgresSchema();
        this.initAfterParameterReading();
    }

    public boolean isUseBinaryFormat() {
        return this.useBinaryFormat;
    }

    public BinaryXmiBuilder getBinaryBuilder() {
        return this.binaryBuilder;
    }

    private void initAfterParameterReading() {
        this.initializationComplete = true;
        int n = this.numAdditionalTables = this.unqualifiedAnnotationModuleNames == null ? 0 : this.unqualifiedAnnotationModuleNames.length;
        if (this.joinTables) {
            for (String annotation : this.unqualifiedAnnotationModuleNames) {
                if (annotation.contains(".")) continue;
                this.initializationComplete = false;
                log.debug(annotation + " is not the fully qualified java name. Will retrieve the fully qualified java name from the types namespace and use this as table name.");
            }
        }
        Map<String, String> nsAndXmiVersion = null;
        if (this.joinTables || this.readsBaseDocument.booleanValue()) {
            try (CoStoSysConnection ignored = this.dbc.obtainOrReserveConnection();){
                nsAndXmiVersion = this.getNamespaceMap();
                if (this.useBinaryFormat) {
                    this.reverseBinaryMapping = this.getReverseBinaryMappingFromDb();
                    this.featuresToMapBinary = this.getFeaturesToMapBinaryFromDb();
                }
            }
        }
        if (!this.useBinaryFormat) {
            this.builder = new XmiBuilder(nsAndXmiVersion, this.unqualifiedAnnotationModuleNames, this.maxXmlAttributeSize);
        } else {
            this.binaryBuilder = new BinaryXmiBuilder(nsAndXmiVersion);
        }
        this.numDataRetrievedDataFields = this.dbc.getFieldConfiguration().getColumnsToRetrieve().length;
        log.info("{}: {}", (Object)PARAM_STORE_XMI_ID, (Object)this.storeMaxXmiId);
        log.info("{}: {}", (Object)PARAM_LOG_FINAL_XMI, (Object)this.logFinalXmi);
        log.info("{}: {}", (Object)PARAM_READS_BASE_DOCUMENT, (Object)this.readsBaseDocument);
        log.info("{}: {}", (Object)PARAM_INCREASED_ATTRIBUTE_SIZE, (Object)this.maxXmlAttributeSize);
        log.info("{}: {}", (Object)PARAM_XERCES_ATTRIBUTE_BUFFER_SIZE, (Object)this.xercesAttributeBufferSize);
        log.info("Data columns set for retrieval: {}", (Object)Arrays.toString(this.dbc.getFieldConfiguration().getColumnsToRetrieve()));
    }

    public void initializeAnnotationTableNames(JCas jCas) throws ResourceInitializationException {
        if (!this.initializationComplete) {
            log.debug("Initializing annotation table table names from type system, if any additional table names are given.");
            String[] additionalTableNames = this.initializable.getAdditionalTableNames();
            String[] tables = this.initializable.getTables();
            TypeSystem typeSystem = jCas.getTypeSystem();
            for (int i = 0; i < additionalTableNames.length; ++i) {
                if (additionalTableNames[i].contains(".")) continue;
                String typeName = "de.julielab.jules.types." + additionalTableNames[i];
                if (typeSystem.getType(typeName) != null) {
                    Object tableName = typeName.replace(".", "_");
                    tables[i + 1] = tableName = this.dbc.getActiveDataPGSchema() + "." + (String)tableName;
                    continue;
                }
                throw new ResourceInitializationException(new IllegalStateException("Could not retrieve the fully qualified java name for type " + additionalTableNames[i] + " from the types namespace in order to use it as table name. Please specify the fully qualified java name for this type"));
            }
        }
    }

    private Map<Integer, String> getReverseBinaryMappingFromDb() {
        HashMap<Integer, String> map;
        block11: {
            map = null;
            String mappingTableName = this.xmiMetaSchema + "._binary_string_mapping";
            if (this.dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                    map = new HashMap<Integer, String>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "mapping_id", "mapping_string", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getInt(1), rs.getString(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(this.xmiMetaSchema + "._binary_string_mapping"));
        }
        return map;
    }

    public Map<Integer, String> getReverseBinaryMapping() {
        return this.reverseBinaryMapping;
    }

    public Map<String, Boolean> getFeaturesToMapBinary() {
        return this.featuresToMapBinary;
    }

    private Map<String, Boolean> getFeaturesToMapBinaryFromDb() {
        HashMap<String, Boolean> map;
        block11: {
            map = null;
            String mappingTableName = this.xmiMetaSchema + "._binary_features_to_map";
            if (this.dbc.tableExists(mappingTableName)) {
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                    map = new HashMap<String, Boolean>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "feature", "map", mappingTableName);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getBoolean(2));
                    }
                    break block11;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block11;
                }
            }
            log.warn("JeDIS XMI annotation module meta table \"{}\" was not found. It is assumed that the table from which is read contains complete XMI documents.", (Object)(this.xmiMetaSchema + "._binary_features_to_map"));
        }
        return map;
    }

    private Map<String, String> getNamespaceMap() {
        String nsTable;
        HashMap<String, String> map;
        block12: {
            map = null;
            nsTable = this.xmiMetaSchema + "._xmi_namespaces";
            if (this.dbc.tableExists(nsTable)) {
                log.debug("Reading XMI namespaces from {}", (Object)nsTable);
                try (CoStoSysConnection conn = this.dbc.obtainOrReserveConnection();){
                    map = new HashMap<String, String>();
                    conn.setAutoCommit(true);
                    Statement stmt = conn.createStatement();
                    String sql = String.format("SELECT %s,%s FROM %s", "prefix", "ns_uri", nsTable);
                    ResultSet rs = stmt.executeQuery(String.format(sql, new Object[0]));
                    while (rs.next()) {
                        map.put(rs.getString(1), rs.getString(2));
                    }
                    break block12;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    SQLException ne = e.getNextException();
                    if (null != ne) {
                        ne.printStackTrace();
                    }
                    break block12;
                }
            }
            throw new IllegalStateException("The table " + nsTable + " does not exist. This is an error since it is required to re-build the XMI data. Is '" + this.xmiMetaSchema + "' the correct Postgres schema for the table?");
        }
        log.debug("Got XMI namespace map from table {}: {}", (Object)nsTable, (Object)map);
        if (map.isEmpty()) {
            throw new IllegalStateException("The table " + nsTable + " is empty. This is an error since it is required to re-build the XMI data. Is '" + this.xmiMetaSchema + "' the correct Postgres schema for the table?");
        }
        return map;
    }

    public boolean getReadsBaseDocument() {
        return this.readsBaseDocument;
    }

    public Boolean getStoreMaxXmiId() {
        return this.storeMaxXmiId;
    }

    public int getNumAdditionalTables() {
        return this.numAdditionalTables;
    }

    public int getNumDataRetrievedDataFields() {
        return this.numDataRetrievedDataFields;
    }

    public Boolean getLogFinalXmi() {
        return this.logFinalXmi;
    }

    public void setLogFinalXmi(Boolean logFinalXmi) {
        this.logFinalXmi = logFinalXmi;
    }

    public DataBaseConnector getDataBaseConnector() {
        return this.dbc;
    }

    public int getXercesAttributeBufferSize() {
        return this.xercesAttributeBufferSize;
    }
}

