/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.xmi;

import de.julielab.costosys.configuration.FieldConfig;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.jcore.reader.db.DBReader;
import de.julielab.jcore.reader.xmi.CasPopulationException;
import de.julielab.jcore.reader.xmi.Initializer;
import de.julielab.jcore.types.Header;
import de.julielab.jcore.types.XmiMetaData;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.xml.XmiBuilder;
import de.julielab.xml.binary.BinaryDecodingResult;
import de.julielab.xml.binary.BinaryJeDISNodeDecoder;
import de.julielab.xml.binary.BinaryXmiBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.StringArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class CasPopulator {
    private static final Logger log = LoggerFactory.getLogger(CasPopulator.class);
    private final DataBaseConnector dbc;
    private final boolean readsBaseDocument;
    private final int numDataRetrievedDataFields;
    private final String[] unqualifiedAnnotationModuleNames;
    private final XmiBuilder builder;
    private final Boolean logFinalXmi;
    private final int xercesAttributeBufferSize;
    private final Boolean storeMaxXmiId;
    private final Boolean readsDataTable;
    private final String tableName;
    private final Map<Integer, String> reverseBinaryMapping;
    private final Map<String, Boolean> featuresToMapBinary;
    private final BinaryXmiBuilder binaryBuilder;
    private final boolean useBinaryFormat;
    private final BinaryJeDISNodeDecoder binaryJeDISNodeDecoder;
    private boolean joinTables;

    public CasPopulator(String dataTable, Initializer initializer, Boolean readDataTable, String tableName) {
        this.dbc = initializer.getDataBaseConnector();
        this.readsDataTable = readDataTable;
        this.tableName = tableName;
        this.readsBaseDocument = initializer.getReadsBaseDocument();
        this.joinTables = initializer.isJoinTables();
        this.numDataRetrievedDataFields = initializer.getNumDataRetrievedDataFields();
        this.unqualifiedAnnotationModuleNames = initializer.getUnqualifiedAnnotationModuleNames();
        this.builder = initializer.getXmiBuilder();
        this.binaryBuilder = initializer.getBinaryBuilder();
        this.useBinaryFormat = initializer.isUseBinaryFormat();
        this.logFinalXmi = initializer.getLogFinalXmi();
        this.xercesAttributeBufferSize = initializer.getXercesAttributeBufferSize();
        this.storeMaxXmiId = initializer.getStoreMaxXmiId();
        this.reverseBinaryMapping = initializer.getReverseBinaryMapping();
        this.featuresToMapBinary = initializer.getFeaturesToMapBinary();
        this.binaryJeDISNodeDecoder = this.useBinaryFormat ? new BinaryJeDISNodeDecoder(Stream.of(this.unqualifiedAnnotationModuleNames).collect(Collectors.toSet()), true) : null;
    }

    public void populateCas(byte[][] data, JCas jCas) throws CasPopulationException {
        String docId = this.getPkStringFromData(data);
        log.debug("Reading document with ID {} as delivered from database.", (Object)docId);
        byte[] documentXmi = data[1];
        if (documentXmi == null) {
            throw new CasPopulationException("The base document XMI data for document with ID " + docId + " is null.");
        }
        long dataSize = documentXmi.length + 100;
        LinkedHashMap<String, InputStream> xmiData = new LinkedHashMap<String, InputStream>();
        FieldConfig fieldConfig = this.dbc.getActiveTableFieldConfiguration();
        int pkLength = fieldConfig.getPrimaryKey().length;
        try {
            int[] xmiColumnIndices;
            for (int i2 : xmiColumnIndices = IntStream.range(pkLength, fieldConfig.getColumnsToRetrieve().length).filter(i -> !fieldConfig.getColumnsToRetrieve()[i].equals("max_xmi_id") && !fieldConfig.getColumnsToRetrieve()[i].equals("sofa_mapping")).toArray()) {
                if (data[i2] == null) continue;
                String columnName = fieldConfig.getFields().get(i2).get("name");
                if (columnName.equals("base_document")) {
                    columnName = "DOCUMENT-MODULE";
                }
                xmiData.put(columnName, new ByteArrayInputStream(data[i2]));
            }
            if (this.joinTables || this.readsBaseDocument) {
                ByteArrayOutputStream baos;
                if (data.length != this.numDataRetrievedDataFields) {
                    throw new CollectionException(new IllegalStateException("The number of retrieved fields does not match the expected number (expected: " + this.numDataRetrievedDataFields + ", actual: " + data.length + "). Make sure to set the primary key fields in the annotation schema to false, since this should be retrieved only once from the document table."));
                }
                log.trace("Received {} bytes of XMI data, taking base document and annotation XMI together", (Object)dataSize);
                if (!this.useBinaryFormat) {
                    this.builder.setInputSize((int)dataSize);
                }
                log.trace("Building complete XMI data from separate XMI base document and annotation data retrieved from the database.");
                try {
                    if (!this.useBinaryFormat) {
                        baos = this.builder.buildXmi(xmiData, jCas.getTypeSystem());
                    } else {
                        BinaryDecodingResult decodingResult = this.binaryJeDISNodeDecoder.decode(xmiData, jCas.getTypeSystem(), this.reverseBinaryMapping, this.featuresToMapBinary, this.binaryBuilder.getNamespaces());
                        baos = this.binaryBuilder.buildXmi(decodingResult);
                    }
                }
                catch (OutOfMemoryError e) {
                    log.error("Document with ID {} could not be built from XMI: {}", (Object)new String(data[0]), (Object)e);
                    log.error("Full error:", e);
                    this.setPrimaryKeyAsDocId(data, true, jCas);
                    return;
                }
                byte[] xmiByteData = baos.toByteArray();
                if (this.logFinalXmi.booleanValue()) {
                    log.info(new String(xmiByteData, StandardCharsets.UTF_8));
                }
                try {
                    log.trace("Deserializing XMI data into the CAS.");
                    JCoReTools.deserializeXmi(jCas.getCas(), new ByteArrayInputStream(xmiByteData), this.xercesAttributeBufferSize);
                }
                catch (SAXException e) {
                    String docData = new String(xmiByteData, StandardCharsets.UTF_8);
                    if (!docData.contains("xmi:XMI xmlns:xmi=\"http://www.omg.org/XMI\"")) {
                        throw new CollectionException(new IllegalArgumentException("The document that has been received from the database does not appear to contain XMI data. The beginning of the document data is: " + StringUtils.abbreviate(docData, 200), e));
                    }
                    log.error("SAXException while deserializing CAS XMI data from a segmented and re-assemblied XMI document. Beginning of data was: {}", (Object)StringUtils.abbreviate(docData, 200));
                    throw new CollectionException(e);
                }
            }
            try {
                XmiCasDeserializer.deserialize(new ByteArrayInputStream(data[1]), jCas.getCas());
            }
            catch (SAXException e) {
                String docData = new String(documentXmi, StandardCharsets.UTF_8);
                if (!docData.contains("xmi:XMI xmlns:xmi=\"http://www.omg.org/XMI\"")) {
                    throw new CollectionException(new IllegalArgumentException("The document that has been received from the database does not appear to contain valid XMI data. The beginning of the document data is: " + StringUtils.abbreviate(docData, 200)));
                }
                log.error("SAXException while deserializing CAS XMI data. Beginning of data was: {}", (Object)StringUtils.abbreviate(docData, 200));
                throw new CollectionException(e);
            }
            log.trace("Setting max XMI ID to the CAS.");
            CasPopulator.storeMaxXmiIdAndSofaMappings(jCas, data, this.storeMaxXmiId);
            log.trace("Setting meta data to: Reads data table: {}, table name: {}", (Object)this.readsDataTable, (Object)this.tableName);
            DBReader.setDBProcessingMetaData(this.dbc, this.readsDataTable, this.tableName, data, jCas);
        }
        catch (Exception e) {
            String pkString = this.setPrimaryKeyAsDocId(data, true, jCas);
            log.error("Got exception while reading document " + pkString, e);
            throw new CasPopulationException(e);
        }
    }

    private String setPrimaryKeyAsDocId(byte[][] data, boolean setPKAsDocId, JCas cas) {
        String pkString = null;
        Header header = null;
        Iterator itHeader = cas.getAnnotationIndex(Header.type).iterator();
        if (itHeader.hasNext()) {
            header = (Header)itHeader.next();
        }
        if (null == header) {
            log.trace("No header found, setting a new one.");
            header = new Header(cas);
            header.addToIndexes();
        }
        if (setPKAsDocId) {
            pkString = this.getPkStringFromData(data);
            header.setDocId(pkString);
        }
        return pkString;
    }

    private String getPkStringFromData(byte[][] data) {
        List<Integer> pkIndices = this.dbc.getPrimaryKeyIndices();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < pkIndices.size(); ++i) {
            Integer index = pkIndices.get(i);
            byte[] pkElementValue = data[index];
            String elementString = new String(pkElementValue);
            sb.append(elementString);
            if (i >= pkIndices.size() - 1) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    public static void storeMaxXmiIdAndSofaMappings(JCas aCAS, byte[][] data, Boolean storeMaxXmiId) {
        if (storeMaxXmiId.booleanValue() && data.length > 2) {
            String docId = JCoReTools.getDocId(aCAS);
            byte[] maxXmiIdBytes = data[2];
            int xmiId = Integer.parseInt(new String(maxXmiIdBytes));
            String mappingString = null;
            if (data.length > 3) {
                mappingString = new String(data[3]);
            }
            for (XmiMetaData xmiMetaData : JCasUtil.select(aCAS, XmiMetaData.class)) {
                xmiMetaData.removeFromIndexes();
            }
            XmiMetaData xmiMetaData = new XmiMetaData(aCAS);
            xmiMetaData.setMaxXmiId(xmiId);
            log.trace("Retrieved max xmi ID {} for document {}.", (Object)xmiMetaData.getMaxXmiId(), (Object)docId);
            String[] mappings = mappingString != null ? mappingString.split("\\|") : null;
            StringArray mappingsArray = null;
            if (mappings != null) {
                mappingsArray = new StringArray(aCAS, mappings.length);
                for (int i = 0; i < mappings.length; ++i) {
                    String mapping = mappings[i];
                    mappingsArray.set(i, mapping);
                    log.trace("Retrieved sofa_id_mapping {} for document {}.", (Object)mappingsArray.get(i), (Object)docId);
                }
            }
            if (mappingsArray != null) {
                xmiMetaData.setSofaIdMappings(mappingsArray);
            }
            xmiMetaData.addToIndexes();
        }
    }
}

