/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.jcore.reader.db;

import de.julielab.costosys.dbconnection.DBCIterator;
import de.julielab.costosys.dbconnection.DataBaseConnector;
import de.julielab.costosys.dbconnection.util.UnobtainableConnectionException;
import de.julielab.jcore.types.casmultiplier.RowBatch;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasMultiplier_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.OperationalProperties;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ResourceMetaData(name="JCoRe Abstract Database Multiplier", description="A multiplier that receives document IDs to read from a database table from the DBMultiplierReader. The reader also delivers the path to the corpus storage system (CoStoSys) configuration and additional tables for joining with the main data table. This multiplier class is abstract and cannot be used directly.Extending classes must implement the next() method to actually read documents from the database and populate CASes with them. This component is a part of the Jena Document Information System, JeDIS.", vendor="JULIE Lab Jena, Germany", copyright="JULIE Lab Jena, Germany")
@OperationalProperties(outputsNewCases=true)
@TypeCapability(inputs={"de.julielab.jcore.types.casmultiplier.RowBatch"})
public abstract class DBMultiplier
extends JCasMultiplier_ImplBase {
    private static final Logger log = LoggerFactory.getLogger(DBMultiplier.class);
    protected DataBaseConnector dbc;
    protected DBCIterator<byte[][]> documentDataIterator;
    protected String[] tables;
    protected String[] schemaNames;
    protected String tableName;
    protected boolean readDataTable;
    protected String dataTable;
    protected boolean initialized;
    private StringArray pkArray;

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.initialized = false;
    }

    protected DataBaseConnector getDataBaseConnector(String costosysConfig) throws AnalysisEngineProcessException {
        DataBaseConnector dbc;
        try {
            dbc = new DataBaseConnector(costosysConfig);
        }
        catch (FileNotFoundException e) {
            throw new AnalysisEngineProcessException(e);
        }
        return dbc;
    }

    @Override
    public void process(JCas aJCas) throws AnalysisEngineProcessException {
        RowBatch rowbatch = JCasUtil.selectSingle(aJCas, RowBatch.class);
        if (rowbatch.getIdentifiers() == null) {
            throw new AnalysisEngineProcessException(new IllegalArgumentException("The identifiers of the passed row batch are null."));
        }
        if (rowbatch.getIdentifiers().size() == 0) {
            throw new AnalysisEngineProcessException(new IllegalArgumentException("The identifiers of the passed row batch are empty."));
        }
        this.tables = rowbatch.getTables().toStringArray();
        this.schemaNames = rowbatch.getTableSchemas().toStringArray();
        this.tableName = rowbatch.getTableName();
        if (!this.initialized) {
            String referencedTable;
            if (this.dbc == null) {
                this.dbc = this.getDataBaseConnector(rowbatch.getCostosysConfiguration());
            }
            try {
                referencedTable = this.dbc.withConnectionQueryString(c -> c.getReferencedTable(rowbatch.getTableName()));
            }
            catch (UnobtainableConnectionException e) {
                throw new AnalysisEngineProcessException(new IllegalArgumentException("The maximum database connection pool size is smaller than 2. However, when reading from database tables, one connection is required the whole time to read documents via cursor from the database and another connection is required to do data consistency checks. Set the number of active connections in the CoStoSys configuration file at least to 2.", e));
            }
            this.readDataTable = referencedTable == null;
            this.dataTable = referencedTable == null ? this.tables[0] : referencedTable;
            this.initialized = true;
        }
        ArrayList<Object[]> documentIdsForQuery = new ArrayList<Object[]>();
        FSArray identifiers = rowbatch.getIdentifiers();
        for (int i = 0; i < identifiers.size(); ++i) {
            StringArray primaryKey = (StringArray)identifiers.get(i);
            documentIdsForQuery.add(primaryKey.toArray());
        }
        if (log.isTraceEnabled()) {
            log.trace("Received document IDs: {}", (Object)documentIdsForQuery.stream().map(o -> Arrays.stream(o).map(Object::toString).collect(Collectors.joining(","))).collect(Collectors.joining(" ; ")));
        }
        this.documentDataIterator = this.dbc.retrieveColumnsByTableSchema(documentIdsForQuery, this.tables, this.schemaNames);
    }

    @Override
    public boolean hasNext() {
        return this.documentDataIterator != null && this.documentDataIterator.hasNext();
    }
}

