/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.java.utilities.prerequisites;

import de.julielab.java.utilities.prerequisites.PrerequisiteChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;

public abstract class ParameterChecker {
    private static final Object[] NULL_ITEM = new Object[]{null};
    protected Object[] items;
    protected List<String> names;
    protected PrerequisiteChecker prerequisiteChecker;

    public ParameterChecker(PrerequisiteChecker prerequisiteChecker, Object ... items) {
        this.prerequisiteChecker = prerequisiteChecker;
        this.items = items != null ? items : NULL_ITEM;
        this.names = Collections.emptyList();
    }

    public void withNames(Queue<String> newNames) {
        if (this.names.isEmpty() && !newNames.isEmpty()) {
            this.names = new ArrayList<String>();
        }
        while (this.names.size() < this.items.length) {
            this.names.add(newNames.poll());
        }
    }

    public abstract void check();

    protected String getName(int index) {
        if (index < this.names.size()) {
            return this.names.get(index);
        }
        if (index < this.items.length) {
            return null;
        }
        throw new ArrayIndexOutOfBoundsException("Given index: " + index + ". There are " + this.items.length + " items with " + this.names.size() + " names.");
    }
}

