/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.ipc.javabridge;

import de.julielab.ipc.javabridge.Reader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringReader
extends Reader<String> {
    private static final Logger log = LoggerFactory.getLogger(StringReader.class);
    private final BufferedReader br;

    public StringReader(InputStream is, Predicate<String> resultLineIndicator, String externalProgramReadySignal) {
        super(is, resultLineIndicator, externalProgramReadySignal);
        this.br = new BufferedReader(new InputStreamReader(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("ReaderThread");
        log.debug("Starting reader thread");
        boolean externalReadySignalSent = this.externalProgramReadySignal == null;
        try {
            String line;
            if (this.externalProgramReadySignal != null) {
                log.debug("Waiting for the signal that the external program is ready ('{}')", (Object)this.externalProgramReadySignal);
            }
            while (!externalReadySignalSent) {
                line = this.br.readLine();
                externalReadySignalSent = line.equals(this.externalProgramReadySignal);
            }
            while ((line = this.br.readLine()) != null) {
                StringReader stringReader = this;
                synchronized (stringReader) {
                    if (this.resultLineIndicator == null || this.resultLineIndicator.test(line)) {
                        if (line.length() > 0) {
                            this.inputDeque.add(line);
                        }
                        this.notify();
                    }
                }
                log.trace("Received: {}", (Object)line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.debug("String reader thread terminates");
    }
}

