/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.utils.dict;

import de.julielab.genemapper.utils.dict.RefCounter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BTMatcher {
    private final int SYN_FIELD = 1;
    private final int ID_FIELD = 0;
    private final HashMap<String, RefCounter> btEntities = new HashMap();

    BTMatcher() {
    }

    private void readBT(File btFile) {
        try {
            String line;
            BufferedReader btReader = new BufferedReader(new FileReader(btFile));
            System.out.println("Importing BioThesaurus: ");
            int counter = 1;
            while ((line = btReader.readLine()) != null) {
                String[] split = line.split("\t");
                if (split[0].equals(" ") || split[0].equalsIgnoreCase("null")) continue;
                String escape = this.cleanEntry(split[1]);
                if (this.btEntities.containsKey(escape)) {
                    TreeSet<String> check = this.btEntities.get(escape).getUniRefs();
                    if (!check.contains(split[0])) {
                        check.add(split[0]);
                        this.btEntities.put(escape, new RefCounter(check));
                    }
                } else {
                    this.btEntities.put(escape, new RefCounter(split[0]));
                }
                if (counter % 10000 == 0) {
                    System.out.println("Read: " + counter);
                }
                ++counter;
            }
            btReader.close();
            System.out.println("Stored synonyms: " + this.btEntities.size());
            System.out.println("Read entries: " + --counter);
        }
        catch (FileNotFoundException file) {
            file.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private String cleanEntry(String escape) {
        escape = escape.replaceAll("-|,", "");
        escape = escape.replace(")", "\\)");
        escape = escape.replace("(", "\\(");
        escape = escape.replace("}", "\\}");
        escape = escape.replace("{", "\\{");
        escape = escape.replace("]", "\\]");
        escape = escape.replace("[", "\\[");
        escape = escape.replace("*", "\\*");
        escape = escape.replace("+", "\\+");
        escape = escape.replace("|", "\\|");
        return escape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readText(File text) {
        StringBuffer textBuffer = new StringBuffer();
        BufferedReader textReader = null;
        try {
            String line;
            textReader = new BufferedReader(new FileReader(text));
            while ((line = textReader.readLine()) != null) {
                textBuffer.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (textReader != null) {
                    textReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return textBuffer.toString().replaceAll("-|,", "");
    }

    public HashMap<String, RefCounter> getFrequencies(String myText) {
        for (String btEntry : this.btEntities.keySet()) {
            RefCounter ref = this.btEntities.get(btEntry);
            Pattern btPattern = Pattern.compile("\\b" + btEntry + "\\b", 2);
            Matcher btMatcher = btPattern.matcher(myText);
            while (btMatcher.find()) {
                ref.increment();
            }
            this.btEntities.put(btEntry, ref);
        }
        return this.btEntities;
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("Usage: BTMatcher <BT file> <text/dir> <outfile>");
            System.exit(-1);
        }
        File bt = new File(args[0]);
        File textSource = new File(args[1]);
        if (!bt.isFile()) {
            System.err.println("Could not find bt file");
            System.exit(-1);
        }
        File outFile = new File(args[2]);
        BTMatcher btMatcher = new BTMatcher();
        HashMap<String, RefCounter> freqs = new HashMap<String, RefCounter>();
        if (textSource.isFile()) {
            btMatcher.readBT(bt);
            String text = btMatcher.readText(textSource);
            freqs = btMatcher.getFrequencies(text);
        } else if (textSource.isDirectory()) {
            File[] content = textSource.listFiles();
            btMatcher.readBT(bt);
            for (int i = 0; i < content.length; ++i) {
                System.out.println("processing file: " + content[i]);
                String text = btMatcher.readText(content[i]);
                freqs = btMatcher.getFrequencies(text);
            }
        } else {
            System.err.println("Could not find file: " + args[1]);
        }
        BTMatcher.writeFreqs(freqs, outFile);
        System.out.println("\n\n matching finished. Output written to: " + outFile);
    }

    private static void writeFreqs(HashMap<String, RefCounter> freqs, File outFile) throws IOException {
        System.out.println("writing results to file...");
        FileWriter fw = new FileWriter(outFile);
        for (String key : freqs.keySet()) {
            RefCounter refC = freqs.get(key);
            int counter = refC.getCounter();
            TreeSet<String> unirefs = refC.getUniRefs();
            for (String unirefID : unirefs) {
                String info = counter + "\t" + key + "\t" + unirefID;
                fw.write(info + "\n");
            }
        }
        fw.close();
    }
}

