/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class UIMAUtils {
    private static FSIterator initializeWindowCursor(JCas jCas, Annotation windowAnnotation) {
        Iterator cursor = jCas.getAnnotationIndex().iterator();
        cursor.moveTo(windowAnnotation);
        while (cursor.isValid() && ((Annotation)cursor.get()).getBegin() >= windowAnnotation.getBegin()) {
            cursor.moveToPrevious();
        }
        if (cursor.isValid()) {
            cursor.moveToNext();
        } else {
            cursor.moveToFirst();
        }
        return cursor;
    }

    public static <T extends Annotation> List<T> getAnnotations(JCas jCas, Annotation windowAnnotation, Class<T> cls) {
        FSIterator cursor = UIMAUtils.initializeWindowCursor(jCas, windowAnnotation);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        while (cursor.isValid() && ((Annotation)cursor.get()).getBegin() <= windowAnnotation.getEnd()) {
            Annotation annotation = (Annotation)cursor.get();
            if (cls.isInstance(annotation) && annotation.getEnd() <= windowAnnotation.getEnd()) {
                annotations.add((Annotation)cls.cast(annotation));
            }
            cursor.moveToNext();
        }
        return annotations;
    }

    public static <T extends Annotation> T getContainingAnnotation(JCas jCas, Annotation focusAnnotation, Class<T> cls) {
        Iterator cursor = jCas.getAnnotationIndex().iterator();
        cursor.moveTo(focusAnnotation);
        while (cursor.isValid() && ((Annotation)cursor.get()).getBegin() == focusAnnotation.getBegin()) {
            cursor.moveToNext();
        }
        if (cursor.isValid()) {
            cursor.moveToPrevious();
        } else {
            cursor.moveTo(focusAnnotation);
        }
        while (cursor.isValid()) {
            Annotation annotation = (Annotation)cursor.get();
            if (cls.isInstance(annotation) && annotation.getBegin() <= focusAnnotation.getBegin() && annotation.getEnd() >= focusAnnotation.getEnd()) {
                return (T)((Annotation)cls.cast(annotation));
            }
            cursor.moveToPrevious();
        }
        return null;
    }
}

