/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.utils;

import de.julielab.geneexpbase.candidateretrieval.SynHit;
import java.util.Collection;
import java.util.Comparator;

public class NDCG {
    public static double[] dcg(double[] gainVector) {
        double[] dcg = new double[gainVector.length];
        for (int i = 0; i < gainVector.length; ++i) {
            double lastValue = i > 1 ? dcg[i - 1] : 0.0;
            dcg[i] = lastValue + gainVector[i] / (Math.log(i + 2) / Math.log(2.0));
        }
        return dcg;
    }

    public static double dcg(double[] gainVector, int k) {
        if (gainVector.length == 0) {
            return 0.0;
        }
        int effectiveK = Math.min(gainVector.length, k);
        double[] dcg = new double[effectiveK];
        for (int i = 0; i < effectiveK; ++i) {
            double lastValue = i > 0 ? dcg[i - 1] : 0.0;
            dcg[i] = lastValue + gainVector[i] / (Math.log(i + 2) / Math.log(2.0));
        }
        return dcg[effectiveK - 1];
    }

    public static double ndcg(double[] gainVector, double[] idealVector, int k) {
        double dcg = NDCG.dcg(gainVector, k);
        double idealdcg = NDCG.dcg(idealVector, k);
        return idealdcg > 0.0 ? dcg / idealdcg : 0.0;
    }

    public static double ndcg(Collection<SynHit> hits, int k) {
        double[] gain = hits.stream().mapToDouble(SynHit::getRelevanceScore).toArray();
        double[] idealGain = hits.stream().sorted(Comparator.comparingDouble(SynHit::getRelevanceScore).reversed()).mapToDouble(SynHit::getRelevanceScore).toArray();
        return NDCG.ndcg(gain, idealGain, k);
    }
}

