/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.ae.genemapper.desc.FamilyResolution.Domain;
import de.julielab.jcore.ae.genemapper.desc.FamilyResolution.Family;
import de.julielab.jcore.types.Protein;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;

@ResourceMetaData(name="JCoRe Protein Family Rules Applier", description="Reads the Family and Domain annotations created by the RUTA FamilyResolution component and applies them to the recognized protein annotations.")
@TypeCapability(inputs={"de.julielab.jcore.types.Protein", "de.julielab.jcore.ae.genemapper.desc.FamilyResolution.Family", "de.julielab.jcore.ae.genemapper.desc.FamilyResolution.Domain"})
public class ProteinFamilyRulesApplier
extends JCasAnnotator_ImplBase {
    @Override
    public void process(JCas jCas) {
        List familyProteins;
        JCoReTreeMapAnnotationIndex proteins = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), TermGenerators.longOffsetTermGenerator(), TermGenerators.longOffsetTermGenerator(), jCas, Protein.type);
        for (Family f : jCas.getAnnotationIndex(Family.type)) {
            familyProteins = proteins.searchFuzzy((Long)((Object)f)).collect(Collectors.toList());
            for (Protein familyProtein : familyProteins) {
                familyProtein.setSpecificType("protein_familiy_or_group");
                familyProtein.setConfidence("1.0");
                familyProtein.setComponentId(familyProtein.getComponentId() + "," + ProteinFamilyRulesApplier.class.getSimpleName());
            }
        }
        for (Domain d : jCas.getAnnotationIndex(Domain.type)) {
            familyProteins = proteins.searchFuzzy((Long)((Object)d)).collect(Collectors.toList());
            for (Protein familyProtein : familyProteins) {
                familyProtein.setSpecificType("DomainMotif");
                familyProtein.setConfidence("1.0");
                familyProtein.setComponentId(familyProtein.getComponentId() + "," + ProteinFamilyRulesApplier.class.getSimpleName());
            }
        }
    }
}

