/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.types.Gene;
import de.julielab.jcore.types.Protein;
import java.util.ArrayList;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

@ResourceMetaData(name="Gene to Protein Annotation Converter", description="Auxiliary component to make annotations of type de.julielab.jcore.types.Protein from de.julielab.jcore.types.Gene annotations. Creates Protein annotations and removes the source Gene annotations. This is useful when the incoming type is Gene because the GeNo components expect Protein annotations.")
@TypeCapability(inputs={"de.julielab.jcore.types.Gene"}, outputs={"de.julielab.jcore.types.Protein"})
public class GeneToProteinConverter
extends JCasAnnotator_ImplBase {
    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (Gene g2 : jCas.getAnnotationIndex(Gene.type)) {
            Protein p = new Protein(jCas, g2.getBegin(), g2.getEnd());
            p.setConfidence(g2.getConfidence());
            p.setComponentId(g2.getComponentId());
            p.setSpecificType(g2.getSpecificType());
            p.setResourceEntryList(g2.getResourceEntryList());
            p.addToIndexes();
            genes.add(g2);
        }
        genes.forEach(TOP::removeFromIndexes);
    }
}

