/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.ae.genemapper.desc.ProteinOffsetExpansion.ExtendedProtein;
import de.julielab.jcore.types.Protein;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.TOP;

@ResourceMetaData(name="JCoRe Extended Proteins Merger", description="Extends Proteins covered by ExtendedProtein annotations.")
@TypeCapability(inputs={"de.julielab.jcore.types.Protein", "de.julielab.jcore.ae.genemapper.desc.ProteinOffsetExpansion.ExtendedProtein"})
public class ExtendedProteinsMerger
extends JCasAnnotator_ImplBase {
    @Override
    public void process(JCas jCas) {
        JCoReTreeMapAnnotationIndex proteins = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), TermGenerators.longOffsetTermGenerator(), TermGenerators.longOffsetTermGenerator(), jCas, Protein.type);
        for (ExtendedProtein ep : jCas.getAnnotationIndex(ExtendedProtein.type)) {
            List<Protein> extendedProteins = proteins.searchFuzzy((Long)((Object)ep)).collect(Collectors.toList());
            extendedProteins.forEach(TOP::removeFromIndexes);
            if (!extendedProteins.isEmpty()) {
                Protein extendedProtein = (Protein)extendedProteins.get(0);
                String newComponentId = extendedProtein.getComponentId() + "," + ExtendedProteinsMerger.class.getSimpleName();
                Protein newProtein = new Protein(jCas, ep.getBegin(), ep.getEnd());
                newProtein.setComponentId(newComponentId);
                newProtein.setConfidence(extendedProtein.getConfidence());
                newProtein.setSpecificType(extendedProtein.getSpecificType());
                newProtein.addToIndexes();
                continue;
            }
            String newComponentId = ExtendedProteinsMerger.class.getSimpleName();
            Protein newProtein = new Protein(jCas, ep.getBegin(), ep.getEnd());
            newProtein.setComponentId(newComponentId);
            newProtein.setSpecificType("protein");
            newProtein.addToIndexes();
        }
    }
}

