/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.uima;

import de.julielab.jcore.types.EmbeddingVector;
import de.julielab.jcore.types.Token;
import de.julielab.jcore.utility.JCoReTools;
import de.julielab.jcore.utility.index.Comparators;
import de.julielab.jcore.utility.index.JCoReTreeMapAnnotationIndex;
import de.julielab.jcore.utility.index.TermGenerators;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.descriptor.ResourceMetaData;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

@ResourceMetaData(name="JCoRe Gene EmbeddingVectors to Tokens Connector", description="This is a helper component for cases where EmbeddingVectors are required to be set to the respective feature of Tokens but the tokens are not connected to the vectors (e.g. because of new tokenization). This simple component just connected existing EmbeddingVector annotations to tokens with overlapping annotations.")
@TypeCapability(inputs={"de.julielab.jcore.types.Token", "de.julielab.jcore.types.EmbeddingVector"})
public class EmbeddingsWithTokensConnectionAnnotator
extends JCasAnnotator_ImplBase {
    @Override
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        JCoReTreeMapAnnotationIndex tokens = new JCoReTreeMapAnnotationIndex(Comparators.longOverlapComparator(), TermGenerators.longOffsetTermGenerator(), TermGenerators.longOffsetTermGenerator(), jCas, Token.type);
        for (EmbeddingVector ev : jCas.getAnnotationIndex(EmbeddingVector.type)) {
            tokens.searchFuzzy((Long)((Object)ev)).forEach(token -> {
                FSArray vectors = JCoReTools.addToFSArray(token.getEmbeddingVectors(), ev);
                token.setEmbeddingVectors(vectors);
            });
        }
    }
}

