/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class UniprotFreeTextHandler
extends DefaultHandler {
    protected HashMap<String, String[]> uniprot2EntrezMap;
    protected TreeMap<String, BufferedWriter> freetextFiles;
    private LinkedList<String> elements;
    private TreeMap<String, StringBuffer> comments;
    private String primaryAccession;
    private String category;
    private String parent;
    private boolean isOnlineInformation;

    public UniprotFreeTextHandler(String output) {
        this.elements = new LinkedList();
        this.primaryAccession = "";
        this.category = "";
        this.comments = new TreeMap();
        this.freetextFiles = new TreeMap();
        this.parent = new File(output).getParent() + File.separator;
    }

    UniprotFreeTextHandler() {
    }

    @Override
    public void startDocument() {
        this.primaryAccession = "";
        this.comments.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        if (qName.equals("comment")) {
            int attsIndex = atts.getIndex("type");
            String value = atts.getValue(attsIndex);
            this.isOnlineInformation = value.equalsIgnoreCase("online information");
            this.category = value;
        }
        this.elements.add(qName);
    }

    @Override
    public void endDocument() {
        if (this.uniprot2EntrezMap.containsKey(this.primaryAccession)) {
            for (String comment : this.comments.keySet()) {
                String uniName = "uniprot_id2" + comment;
                String entrezName = "entrezgene_id2" + comment;
                try {
                    String[] entrezIDs;
                    BufferedWriter uniRaf = this.freetextFiles.containsKey(uniName) ? this.freetextFiles.get(uniName) : new BufferedWriter(new FileWriter(uniName));
                    BufferedWriter entrezRaf = this.freetextFiles.containsKey(entrezName) ? this.freetextFiles.get(entrezName) : new BufferedWriter(new FileWriter(entrezName));
                    String text = "\t" + this.comments.get(comment) + "\n";
                    uniRaf.write(this.primaryAccession + text);
                    for (String id : entrezIDs = this.uniprot2EntrezMap.get(this.primaryAccession)) {
                        entrezRaf.write(id + text);
                    }
                    this.freetextFiles.put(uniName, uniRaf);
                    this.freetextFiles.put(entrezName, entrezRaf);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.elements.removeLast();
    }

    private void stopParser() throws SAXException {
        this.fatalError(new SAXParseException("No corresponding ID!", null));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String element = this.elements.getLast();
        if (this.primaryAccession.length() == 0 && element.equals("accession")) {
            int size = this.elements.size();
            if (size >= 2 && (element = this.elements.get(size - 2)).equals("entry")) {
                this.primaryAccession = new String(ch).substring(start, start + length);
            }
        } else if (element.equals("name") || element.equals("acronym") && this.category.equals("disease")) {
            String content = new String(ch, start, length);
            this.comments.compute(this.category, (k, v) -> v == null ? new StringBuffer(content) : v.append(" ").append(content));
        } else if (element.equals("tissue")) {
            String content = new String(ch, start, length);
            this.comments.put("tissue", new StringBuffer(content));
        } else if (element.equals("text")) {
            int size = this.elements.size();
            if (size >= 2 && (element = this.elements.get(size - 2)).equalsIgnoreCase("comment") && !this.isOnlineInformation) {
                StringBuffer storage = this.comments.containsKey(this.category) ? this.comments.get(this.category) : new StringBuffer();
                storage.append((String)(storage.length() == 0 ? new String(ch).substring(start, start + length) : " " + new String(ch).substring(start, start + length)));
                this.comments.put(this.category, storage);
            }
        } else if (element.equals("keyword")) {
            StringBuffer keywords = this.comments.containsKey("keyword") ? this.comments.get("keyword") : new StringBuffer();
            keywords.append((String)(keywords.length() == 0 ? new String(ch).substring(start, start + length) : " " + new String(ch).substring(start, start + length)));
            this.comments.put("keyword", keywords);
        }
    }
}

