/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.store.FSDirectory;

public class SpellCheckerIndexGenerator {
    public static void main(String[] args) throws Exception {
        Object indexPath;
        Object resPath;
        File resDir;
        if (args.length != 2) {
            System.err.println("Usage: SpellCheckerIndexGenerator <resourcesDirectory> <geneSynonymIndicesDirectory>");
            System.exit(1);
        }
        if (!(resDir = new File((String)(resPath = args[0]))).isDirectory()) {
            System.err.println("Could not find resources directory");
            System.exit(1);
        }
        if (!((String)resPath).endsWith(File.separator)) {
            resPath = (String)resPath + File.separator;
        }
        if (!((String)(indexPath = args[1])).endsWith("/")) {
            indexPath = (String)indexPath + "/";
        }
        File geneIndexDir = new File((String)indexPath + "geneSynonymIndex");
        File proteinIndexDir = new File((String)indexPath + "proteinSynonymIndex");
        File geneSpellingIndexDir = new File((String)indexPath + "geneSpellingIndex");
        File proteinSpellingIndexDir = new File((String)indexPath + "proteinSpellingIndex");
        System.out.println("Writing gene spelling index to " + geneSpellingIndexDir.getAbsolutePath());
        SpellCheckerIndexGenerator.createSpellingIndex(geneIndexDir, geneSpellingIndexDir);
        System.out.println("Done.");
    }

    public static void createSpellingIndex(File mentionIndexDir, File spellingIndexDir) throws IOException {
        DirectoryReader reader = DirectoryReader.open(FSDirectory.open(mentionIndexDir.toPath()));
        LuceneDictionary dictionary = new LuceneDictionary(reader, "indexed_syn");
        WhitespaceAnalyzer wsAnalyzer = new WhitespaceAnalyzer();
        IndexWriterConfig iwc = new IndexWriterConfig(wsAnalyzer);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try (SpellChecker sc = new SpellChecker(FSDirectory.open(spellingIndexDir.toPath()));){
            sc.indexDictionary(dictionary, iwc, true);
        }
    }
}

