/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;

public class MultiStreamBZip2InputStream
extends CompressorInputStream {
    private final InputStream fInputStream;
    private BZip2CompressorInputStream fBZip2;

    public MultiStreamBZip2InputStream(InputStream in) throws IOException {
        this.fInputStream = in;
        this.fBZip2 = new BZip2CompressorInputStream(in);
    }

    @Override
    public int read() throws IOException {
        int ch = this.fBZip2.read();
        if (ch == -1 && this.fInputStream.available() > 0) {
            this.fBZip2 = new BZip2CompressorInputStream(this.fInputStream);
            ch = this.fBZip2.read();
        }
        return ch;
    }

    @Override
    public int read(byte[] dest, int off, int len) throws IOException {
        int i;
        if (off < 0 || len < 0 || off + len > dest.length) {
            throw new IndexOutOfBoundsException("Reading " + len + " bytes from offset " + off + " which sums to " + off + len + " but there are only " + dest.length + " bytes.");
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        dest[off++] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            dest[off++] = (byte)c;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.fBZip2.close();
        this.fInputStream.close();
    }
}

