/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import de.julielab.jcore.types.Organism;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

public class LinnaeusApplication {
    private final AnalysisEngine linnaeusAE;
    private final JCas jcas;

    public static void main(String[] args) throws IOException, UIMAException {
        Index index;
        if (args.length != 3) {
            System.err.println("Usage: " + LinnaeusApplication.class.getSimpleName() + " <tab separated input file> <comma separated column indexes to replace with tax IDs or column range given by from-to where to may be omitted> <output file>");
            System.exit(1);
        }
        File input = new File(args[0]);
        File output = new File(args[2]);
        List specifiedCols = null;
        int specifiedRangeStart = -1;
        int specifiedRangeEnd = -1;
        if (args[1].contains(",") || !args[1].contains("-")) {
            specifiedCols = Stream.of(args[1].split(",")).map(i -> Integer.parseInt(i)).collect(Collectors.toList());
            index = Index.SPECIFIC;
        } else {
            index = Index.RANGE;
            String[] split2 = args[1].split("-");
            specifiedRangeStart = Integer.parseInt(split2[0]);
            if (split2.length == 2) {
                specifiedRangeEnd = Integer.parseInt(split2[1]);
            } else if (split2.length > 2) {
                throw new IllegalArgumentException("The range specification '" + args[1] + "' is invalid, please specify one begin and at most one end offset.");
            }
        }
        List cols = specifiedCols;
        int rangeStart = specifiedRangeStart;
        int rangeEnd = specifiedRangeEnd;
        String descriptor = "de.julielab.jules.resources.linnaeus.genera_proxies.jules-linnaeus-species-ae";
        LinnaeusApplication app = new LinnaeusApplication(descriptor);
        try (BufferedWriter bw = Files.newBufferedWriter(output.toPath(), new OpenOption[0]);){
            Files.lines(input.toPath(), StandardCharsets.UTF_8).map(l -> l.split("\\t")).map(split -> {
                int col;
                ArrayList<Integer> effectiveCols;
                ArrayList<Integer> arrayList2 = effectiveCols = cols != null ? new ArrayList<Integer>(cols) : new ArrayList();
                if (index == Index.RANGE) {
                    int end = rangeEnd == -1 ? ((String[])split).length - 1 : rangeEnd;
                    for (col = rangeStart; col <= end; ++col) {
                        effectiveCols.add(col);
                    }
                }
                Iterator iterator = effectiveCols.iterator();
                while (iterator.hasNext()) {
                    col = (Integer)iterator.next();
                    split[col] = app.tagSpecies(split[col]);
                }
                return split;
            }).filter(split -> {
                int col;
                ArrayList<Integer> effectiveCols;
                ArrayList<Integer> arrayList2 = effectiveCols = cols != null ? new ArrayList<Integer>(cols) : new ArrayList();
                if (index == Index.RANGE) {
                    int end = rangeEnd == -1 ? ((String[])split).length - 1 : rangeEnd;
                    for (col = rangeStart; col <= end; ++col) {
                        effectiveCols.add(col);
                    }
                }
                Iterator iterator = effectiveCols.iterator();
                while (iterator.hasNext()) {
                    col = (Integer)iterator.next();
                    if (split[col] == null || split[col].trim().length() <= 0) continue;
                    return true;
                }
                return false;
            }).forEach(split -> {
                try {
                    bw.write(Stream.of(split).collect(Collectors.joining("\t")) + "\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }

    public LinnaeusApplication(String descriptor) throws IOException, UIMAException {
        File descriptorFile = new File(descriptor);
        this.linnaeusAE = descriptorFile.exists() ? AnalysisEngineFactory.createEngineFromPath(descriptorFile.getAbsolutePath(), new Object[0]) : AnalysisEngineFactory.createEngine(descriptor, new Object[0]);
        this.jcas = JCasFactory.createJCas("de.julielab.jcore.types.jcore-all-types");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String tagSpecies(String input) {
        try {
            String taxIds;
            File inputFile = new File(input);
            String text = inputFile.exists() ? new String(Files.readAllBytes(inputFile.toPath()), StandardCharsets.UTF_8) : input;
            if (text == null || text.length() == 0) {
                System.err.println("Text contents are empty, aborting process.");
                String string = "";
                return string;
            }
            this.jcas.setDocumentText(text);
            this.linnaeusAE.process(this.jcas);
            Collection<Organism> organisms = JCasUtil.select(this.jcas, Organism.class);
            String string = taxIds = organisms.stream().map(o -> o.getResourceEntryList(0).getEntryId()).collect(Collectors.joining(";"));
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AnalysisEngineProcessException e) {
            e.printStackTrace();
        }
        finally {
            this.jcas.reset();
        }
        return "";
    }

    public static enum Index {
        SPECIFIC,
        RANGE;

    }
}

