/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IDReplacer {
    private final File dbFile;
    private final int dbIndex;
    private final File mappingFile;
    private final int mappingIndex;
    private Map<String, List<String>> mapping;
    private final File output;

    public Map<String, List<String>> getMapping() {
        return this.mapping;
    }

    public IDReplacer(File dbFile, int dbIndex, File mappingFile, int mappingIndex) throws IOException {
        this(dbFile, dbIndex, mappingFile, mappingIndex, null);
    }

    public IDReplacer(File dbFile, int dbIndex, File mappingFile, int mappingIndex, File output) throws IOException {
        this.dbFile = dbFile;
        this.dbIndex = dbIndex;
        this.mappingFile = mappingFile;
        this.mappingIndex = mappingIndex;
        this.output = output;
        if (!(dbFile == null || dbFile.exists() && dbFile.isFile())) {
            throw new IOException(dbFile.getAbsolutePath() + " does not exist or is not a regular file (maybe a directory?)");
        }
        if (!(mappingFile == null || mappingFile.exists() && mappingFile.isFile())) {
            throw new IOException(mappingFile.getAbsolutePath() + " does not exist or is not a regular file (maybe a directory?)");
        }
    }

    public void readMapping() throws IOException {
        this.mapping = Files.lines(this.mappingFile.toPath(), StandardCharsets.UTF_8).map(l -> l.split("\\t")).collect(Collectors.groupingBy(s2 -> s2[this.mappingIndex], Collectors.mapping(s2 -> s2[1 - this.mappingIndex], Collectors.toList())));
    }

    public void replace() throws IOException {
        Stream mappedDbLines = Files.lines(this.dbFile.toPath(), StandardCharsets.UTF_8).map(l -> l.split("\\t")).filter(s2 -> this.mapping.containsKey(s2[this.dbIndex])).flatMap(s2 -> this.mapping.get(s2[this.dbIndex]).stream().map(id -> {
            s2[this.dbIndex] = id;
            return Stream.of(s2).collect(Collectors.joining("\t"));
        }));
        if (this.output != null) {
            Files.write(this.output.toPath(), () -> mappedDbLines.iterator(), StandardCharsets.UTF_8, new OpenOption[0]);
        } else {
            mappedDbLines.forEach(System.out::println);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 4 || args.length > 5) {
            System.out.println("Usage: " + IDReplacer.class.getName() + " <database file> <database ID column index> <mapping file> <mapping file source ID column index> [output file]");
            System.exit(1);
        }
        File dbFile = new File(args[0]);
        int dbIndex = Integer.parseInt(args[1]);
        File mappingFile = new File(args[2]);
        int mappingIndex = Integer.parseInt(args[3]);
        File output = null;
        if (args.length > 4 && args[4].trim().length() > 0) {
            output = new File(args[4]);
        }
        IDReplacer replacer = new IDReplacer(dbFile, dbIndex, mappingFile, mappingIndex, output);
        replacer.readMapping();
        replacer.replace();
    }
}

