/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GOExport {
    private static final int CELLULAR_FILE = 3;
    private static final int MOLECULAR_FILE = 2;
    private static final int BIOLOGICAL_FILE = 1;
    private static final int ID = 1;
    private static final int NAME = 2;
    private static final int NAMESPACE = 3;
    protected static final String CELLULAR_COMPONENT = "cellular_component";
    protected static final String MOLECULAR_FUNCTION = "molecular_function";
    protected static final String BIOLOGICAL_PROCESS = "biological_process";
    private static final Logger LOGGER = LoggerFactory.getLogger(GOExport.class);
    private static final String LOGGER_PROPERTIES = "log4j.properties";

    public static void main(String[] args) {
        GOExport export = new GOExport();
        if (args.length == 1) {
            export.process(args[0]);
        } else {
            System.out.println("usage: GOExport Gene_Ontology");
        }
    }

    protected void process(String go) {
        File goFile = new File(go);
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new FileInputStream(goFile)), StandardCharsets.UTF_8));
            String parent = goFile.getParent();
            BufferedWriter process = new BufferedWriter(new FileWriter(BIOLOGICAL_PROCESS));
            BufferedWriter function = new BufferedWriter(new FileWriter(MOLECULAR_FUNCTION));
            BufferedWriter component = new BufferedWriter(new FileWriter(CELLULAR_COMPONENT));
            while ((line = br.readLine()) != null && !line.equals("")) {
            }
            ArrayList<String> term = new ArrayList<String>(10);
            while ((line = br.readLine()) != null) {
                if (!line.equals("")) {
                    term.add(line);
                    continue;
                }
                int dest = this.getNamespace(term);
                String condensedForm = this.evaluateTerm(term, dest == 2);
                switch (dest) {
                    case 1: {
                        process.write(condensedForm + "\n");
                        process.flush();
                        break;
                    }
                    case 2: {
                        function.write(condensedForm + "\n");
                        function.flush();
                        break;
                    }
                    case 3: {
                        component.write(condensedForm + "\n");
                        component.flush();
                        break;
                    }
                    default: {
                        if (condensedForm.length() == 0) break;
                        LOGGER.warn("Unrecognized namespace!");
                    }
                }
                term.clear();
            }
            process.close();
            function.close();
            component.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int getNamespace(ArrayList<String> term) {
        int index;
        String namespace = term.get(3);
        String namespaceType = namespace.substring(index = namespace.indexOf(58) + 1).trim();
        int dest = namespaceType.equals(BIOLOGICAL_PROCESS) ? 1 : (namespaceType.equals(MOLECULAR_FUNCTION) ? 2 : (namespaceType.equals(CELLULAR_COMPONENT) ? 3 : -1));
        return dest;
    }

    private String evaluateTerm(ArrayList<String> term, boolean isMol) {
        StringBuffer entry = new StringBuffer();
        if (term.get(0).equals("[Term]")) {
            String id = term.get(1);
            int index = id.indexOf(58) + 1;
            entry.append(id.substring(index).trim() + "\t");
            String name = term.get(2);
            index = name.indexOf(58) + 1;
            name = name.substring(index).trim();
            name = isMol && name.endsWith(" activity") ? name.substring(0, name.length() - 9) : name;
            entry.append(name);
            for (int i = 3; i < term.size(); ++i) {
                String feature = term.get(i);
                String featureType = feature.substring(0, index = feature.indexOf(58));
                if (!featureType.contains("synonym")) continue;
                int begin = feature.indexOf(34) + 1;
                int end = feature.indexOf(34, begin);
                feature = feature.substring(begin, end);
                feature = isMol && feature.endsWith(" activity") ? feature.substring(0, feature.length() - 9) : feature;
                entry.append("|" + feature);
            }
        }
        return entry.toString();
    }
}

