/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import de.julielab.geneexpbase.CandidateFilter;
import de.julielab.genemapper.resources.DictionaryGeneralFilter;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryFamilyDomainFilter {
    private static final Logger log = LoggerFactory.getLogger(DictionaryFamilyDomainFilter.class);
    private static final int MAX_SYNLENGTH = 9;
    private static final int MIN_SYNLENGTH = 2;

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Usage: " + DictionaryGeneralFilter.class.getSimpleName() + " <input dictionary> <output dictionary>");
            System.exit(1);
        }
        File input = new File(args[0]);
        File output = new File(args[1]);
        try (BufferedReader br = FileUtilities.getReaderFromFile(input);
             BufferedWriter bw = FileUtilities.getWriterToFile(output);){
            DictionaryFamilyDomainFilter.cleanDictionary(input, output, br, bw);
        }
        catch (IOException e) {
            log.error("Could not read or write", e);
            throw e;
        }
    }

    private static void cleanDictionary(File input, File output, BufferedReader br, BufferedWriter bw) throws IOException {
        log.info("Reading dictionary from {} and writing the filtered output to {}", (Object)input, (Object)output);
        CandidateFilter cf = new CandidateFilter();
        ((Stream)br.lines().parallel()).forEach(line -> {
            try {
                DictionaryFamilyDomainFilter.processLine(cf, bw, line);
            }
            catch (IOException e) {
                log.error("Could not write to the filtered dictionary", e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLine(CandidateFilter cf, BufferedWriter bw, String line) throws IOException {
        String[] split = line.split("\t");
        if (split.length != 3) {
            log.error("ERR: normalized dictionary not in expected format. \ncritical line: {}", (Object)line);
        }
        String synonym = split[0];
        String id = split[1];
        Integer priority = Integer.parseInt(split[2]);
        boolean filtered = DictionaryFamilyDomainFilter.isFiltered(id, cf, synonym);
        if (priority != -1 && filtered) {
            return;
        }
        BufferedWriter bufferedWriter = bw;
        synchronized (bufferedWriter) {
            bw.write(line);
            bw.newLine();
        }
    }

    public static boolean isFiltered(String id, CandidateFilter cf, String synonym) {
        boolean filtered = false;
        int synTokenNum = synonym.split(" ").length;
        if (synTokenNum > 9 || synTokenNum < 2 && synonym.length() < 2) {
            log.debug("Removed due to illegal length (too short or too long): {}", (Object)synonym);
            filtered = true;
        }
        boolean filteredBecauseUnspecific = DictionaryFamilyDomainFilter.checkNoGeneDesignation(cf, synonym);
        if (!filtered && filteredBecauseUnspecific) {
            filtered = true;
        }
        return filtered;
    }

    private static boolean checkNoGeneDesignation(CandidateFilter cf, String normalizedName) {
        boolean filtered = false;
        Pattern p = CandidateFilter.patternDomainFamilies;
        Matcher m3 = p.matcher(normalizedName);
        if (m3.matches()) {
            log.debug("DOMAIN/FAMILY REMOVED: |{}|", (Object)normalizedName);
            filtered = true;
        }
        if ((m3 = (p = CandidateFilter.patternUnspecifieds).matcher(normalizedName)).matches()) {
            log.debug("UNSPECIFIED REMOVED: |{}|", (Object)normalizedName);
            filtered = true;
        }
        return filtered;
    }
}

