/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import de.julielab.geneexpbase.TermNormalizer;
import de.julielab.java.utilities.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextItemRecordsIndexGenerator {
    private static final Logger log = LoggerFactory.getLogger(ContextItemRecordsIndexGenerator.class);
    private final Directory indexDirectory;
    private final boolean normalizeContexts;
    private final File idFile;
    private final String resourcesDir;

    public ContextItemRecordsIndexGenerator(File idFile, File indexFile, String resourcesDir, boolean normalizeContexts) {
        this.idFile = idFile;
        this.resourcesDir = resourcesDir;
        this.indexDirectory = this.createIndexDirectory(indexFile);
        this.normalizeContexts = normalizeContexts;
    }

    public static void main(String[] args) {
        File egFile;
        File upFile;
        Object resPath;
        File resDir;
        boolean normalizeContexts;
        Object indexBaseDir;
        long s1 = System.currentTimeMillis();
        if (args.length != 3) {
            System.err.println("Usage: SynonymDisambiguationIndexGenerator <resourcesDirectory> <geneContextIndicesDirectory> <normalize contexts>");
            System.exit(-1);
        }
        if (!((String)(indexBaseDir = args[1])).endsWith(File.separator)) {
            indexBaseDir = (String)indexBaseDir + File.separator;
        }
        String nameSuffix = (normalizeContexts = Boolean.parseBoolean(args[2])) ? "Normalized" : "Original";
        File geneIndexDir = new File((String)indexBaseDir + "geneContextItemsIndex" + nameSuffix);
        File proteinIndexDir = new File((String)indexBaseDir + "proteinContextItemsIndex" + nameSuffix);
        if (geneIndexDir.exists()) {
            FileUtils.deleteQuietly(geneIndexDir);
        }
        if (proteinIndexDir.exists()) {
            FileUtils.deleteQuietly(proteinIndexDir);
        }
        if (!(resDir = new File((String)(resPath = args[0]))).isDirectory()) {
            System.err.println("Could not find resources directory");
            System.exit(-1);
        }
        if (!((String)resPath).endsWith(File.separator)) {
            resPath = (String)resPath + File.separator;
        }
        if (!(upFile = new File((String)resPath + "up.ids")).isFile()) {
            System.err.println("Could not find file uniprot.ids");
            System.exit(-1);
        }
        if (!(egFile = new File((String)resPath + "eg.ids")).isFile()) {
            System.err.println("Could not find file eg.ids");
            System.exit(-1);
        }
        try {
            ContextItemRecordsIndexGenerator indexGenerator = new ContextItemRecordsIndexGenerator(upFile, proteinIndexDir, (String)resPath, normalizeContexts);
            indexGenerator.createIndex("protein");
            indexGenerator = new ContextItemRecordsIndexGenerator(egFile, geneIndexDir, (String)resPath, normalizeContexts);
            indexGenerator.createIndex("gene");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long s2 = System.currentTimeMillis();
        System.out.println("Indices created successfully! (" + (s2 - s1) / 1000L + " sec)");
    }

    public void createIndex(String idType) throws IOException {
        String typePrefix = idType.equals("gene") ? "eg" : "up";
        HashMap<String, Multimap<String, String>> contextMaps = new HashMap<String, Multimap<String, String>>();
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2generif").toFile(), contextMaps, "generif");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2interaction").toFile(), contextMaps, "interaction");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2summary").toFile(), contextMaps, "summary");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2description").toFile(), contextMaps, "description");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2chromosome").toFile(), contextMaps, "chromosome");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2maplocation").toFile(), contextMaps, "map_location");
        this.readContextInformation(Path.of(this.resourcesDir, typePrefix + "2synonyms").toFile(), contextMaps, "synonyms_bow");
        IndexWriterConfig iwc = new IndexWriterConfig(new WhitespaceAnalyzer());
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter contextIndexWriter = new IndexWriter(this.indexDirectory, iwc);
        TermNormalizer normalizer = new TermNormalizer();
        AtomicInteger counter = new AtomicInteger();
        Function<Object, Object> contextTransformation = this.normalizeContexts ? context -> normalizer.normalize((String)context) : Function.identity();
        log.info("Writing index {}", (Object)this.indexDirectory);
        try (BufferedReader idReader = new BufferedReader(new FileReader(this.idFile));){
            ((Stream)idReader.lines().parallel()).forEach(id -> {
                try {
                    ArrayList<Field> fields = new ArrayList<Field>();
                    for (String contextField : contextMaps.keySet()) {
                        Collection contextItems = ((Multimap)contextMaps.get(contextField)).get(id);
                        if (contextItems == null) continue;
                        StringField lookupIdField = new StringField("indexed_id", (String)id, Field.Store.YES);
                        fields.add(lookupIdField);
                        Iterator iterator = contextItems.iterator();
                        while (iterator.hasNext()) {
                            String contextItem;
                            String contextString = contextItem = (String)iterator.next();
                            if (contextField.equals("synonyms_bow")) {
                                CharSequence[] synonyms = contextString.split("\u00a7sep\u00a7");
                                contextString = String.join((CharSequence)" ", synonyms);
                                for (CharSequence synonym : synonyms) {
                                    if (((String)synonym).isBlank()) continue;
                                    StringField exactSynonymsField = new StringField("synonyms_exact", (String)contextTransformation.apply(synonym), Field.Store.YES);
                                    fields.add(exactSynonymsField);
                                }
                            }
                            TextField lookupContextField = new TextField(contextField, (String)contextTransformation.apply(contextString), Field.Store.YES);
                            fields.add(lookupContextField);
                        }
                    }
                    Document d = new Document();
                    for (Field f : fields) {
                        d.add(f);
                    }
                    contextIndexWriter.addDocument(d);
                    counter.incrementAndGet();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            contextIndexWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info("Done writing context item index for {} ids.", (Object)counter);
    }

    private void readContextInformation(File contextFile, Map<String, Multimap<String, String>> contextMaps, String fieldname) throws IOException {
        HashMultimap context = HashMultimap.create();
        try (BufferedReader br = FileUtilities.getReaderFromFile(contextFile);){
            br.lines().filter(Predicate.not(line -> line.startsWith("#"))).map(line -> line.split("\t")).filter(s2 -> {
                if (((String[])s2).length < 2) {
                    log.warn("Skipping split {} because there are not enough fields", s2);
                }
                return ((String[])s2).length > 1;
            }).forEach(split -> context.put(split[0].intern(), split[1]));
        }
        catch (Exception e) {
            log.error("Could not load context file {}", (Object)contextFile, (Object)e);
            throw e;
        }
        log.info("Reading context file {} with {} entries", (Object)contextFile, (Object)context.size());
        contextMaps.put(fieldname, context);
    }

    private FSDirectory createIndexDirectory(File indexFile) {
        FSDirectory fdir = null;
        try {
            fdir = FSDirectory.open(indexFile.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fdir;
    }
}

