/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.resources;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

public class BioThesaurusIproClassMerger {
    HashMap<String, String[]> iproCols = new HashMap();

    BioThesaurusIproClassMerger() {
    }

    private void importIproClass(File iproFile, boolean allColumnsRead) {
        try (BufferedReader iproReader = new BufferedReader(new FileReader(iproFile));){
            String line;
            int counter = 1;
            System.out.println("Importing lines from IproClass!");
            while ((line = iproReader.readLine()) != null) {
                String[] split = line.split("\t");
                if (allColumnsRead) {
                    this.iproCols.put(split[0].intern(), new String[]{split[1].intern(), split[11].intern(), split[12].intern(), split[15].intern()});
                } else {
                    this.iproCols.put(split[0].intern(), new String[]{split[1].intern(), split[2].intern(), split[3].intern(), split[4].intern()});
                }
                if (counter % 100000 == 0) {
                    System.out.println(counter);
                }
                ++counter;
            }
            System.out.println("iproclass: " + this.iproCols.size() + " lines imported!");
        }
        catch (FileNotFoundException file) {
            file.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    private void appendCols(File btFile, String outputFile) {
        try (BufferedReader bioReader = new BufferedReader(new FileReader(btFile));
             BufferedWriter bioWriter = new BufferedWriter(new FileWriter(outputFile));){
            Object line;
            System.out.println("Appending columns to BioThesaurus: ");
            int counter = 1;
            while ((line = bioReader.readLine()) != null) {
                String[] split = ((String)line).split("\t");
                if (this.iproCols.containsKey(split[0].intern())) {
                    String[] ipro = this.iproCols.get(split[0].intern());
                    line = (String)line + "\t" + ipro[0].intern() + "\t" + ipro[1].intern() + "\t" + ipro[2].intern() + "\t" + ipro[3].intern() + "\n";
                    bioWriter.write((String)line);
                    bioWriter.flush();
                }
                if (counter % 10000 == 0) {
                    System.out.println(counter);
                }
                ++counter;
            }
            bioReader.close();
            bioWriter.close();
            System.out.println("Finished merging!");
        }
        catch (FileNotFoundException file) {
            file.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public static void main(String[] args) {
        BioThesaurusIproClassMerger merger = new BioThesaurusIproClassMerger();
        if (args.length == 4) {
            File btFile = new File(args[0]);
            File iproFile = new File(args[1]);
            String outputFile = args[2];
            boolean allCols = new Boolean(args[3]);
            if (btFile.isFile() && iproFile.isFile()) {
                merger.importIproClass(iproFile, allCols);
                merger.appendCols(btFile, outputFile);
            } else {
                System.err.println("Could not find one or both files!");
            }
        } else {
            System.err.println("Too many/few arguments\nUsage: <bt file> <ip file> <output file> <allCols true/false>");
        }
    }
}

