/*
 * Decompiled with CFR 0.152.
 */
package de.julielab.genemapper.mappingcores.quercus;

import de.julielab.geneexpbase.candidateretrieval.SynHit;
import de.julielab.geneexpbase.configuration.Configuration;
import de.julielab.geneexpbase.genemodel.GeneMention;
import de.julielab.genemapper.disambig.SemanticContextIndex;
import de.julielab.genemapper.mappingcores.quercus.QuercusDisambiguationStep;
import de.julielab.genemapper.utils.ContextUtils;
import de.julielab.genemapper.utils.GeneMapperException;
import de.julielab.genemapper.utils.GeneMapperRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticIndexDisambiguationStep
implements QuercusDisambiguationStep {
    private static final Logger log = LoggerFactory.getLogger(SemanticIndexDisambiguationStep.class);
    private IndexSearcher searcher;
    private SemanticContextIndex semanticContextIndex;

    @Inject
    public SemanticIndexDisambiguationStep(Configuration config) throws GeneMapperException {
        try {
            String semIndexFile = config.getProperty("semantic_index");
            if (semIndexFile != null) {
                this.semanticContextIndex = new SemanticContextIndex(new File(semIndexFile));
                this.searcher = this.semanticContextIndex.getSemanticIndexSearcher();
            } else {
                log.debug("No path to semantic context index specified.");
            }
        }
        catch (IOException e) {
            throw new GeneMapperException(e);
        }
    }

    @Override
    public void disambiguate(GeneMention gm, SynHit candidate) {
        try {
            BooleanQuery contextQuery = ContextUtils.makeContextQuery(gm.getGeneDocument().getDocumentContext(gm.getOffsets(), 500).collect(Collectors.joining(" ")));
            for (String taxId : gm.getNonRejectedTaxonomyIds()) {
                List<SynHit> synHits = gm.getMentionMappingResult().tax2lexicallyRerankedCandidates.get(taxId);
                SynHit firstSh = synHits.iterator().next();
                if (firstSh.isDisambiguated()) continue;
                this.doDisambiguation(firstSh, contextQuery, 0.0);
            }
        }
        catch (IOException e) {
            throw new GeneMapperRuntimeException(e);
        }
    }

    public SynHit doDisambiguation(SynHit synHit, Query query, double minContextScore) throws IOException {
        TopDocs foundDocs = this.getContextForSynHits(synHit, query);
        ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
        String bestHit = null;
        float bestScore = 0.0f;
        for (int i = 0; i < scoredDocs.length; ++i) {
            Document d = this.searcher.doc(scoredDocs[i].doc);
            String id = d.getField("indexed_id").stringValue();
            float score = scoredDocs[i].score;
            if (score > bestScore) {
                bestScore = score;
                bestHit = id;
            }
            log.debug("hit: " + id);
            log.debug("TFIDF semantic score is: " + score);
        }
        if (bestHit != null) {
            synHit.setId(bestHit);
            synHit.setContextualScore(bestScore);
        } else {
            log.debug("No context results for SynHit, disambiguation not happening: {}", (Object)synHit);
        }
        return synHit;
    }

    public TopDocs getContextForSynHits(SynHit synHit, Query query) throws IOException {
        log.debug("number of IDs: " + synHit.getIds().size());
        Query q = this.makeQuery(synHit.getIds(), query);
        log.debug("query: " + q);
        TopDocs foundDocs = this.searcher.search(q, synHit.getIds().size());
        ScoreDoc[] scoredDocs = foundDocs.scoreDocs;
        log.debug("scoredDocs.length: {}", (Object)scoredDocs.length);
        return foundDocs;
    }

    public Query makeQuery(List<String> allowedIDs, Query query) throws IOException {
        BooleanQuery.Builder idQuery = new BooleanQuery.Builder();
        for (int i = 0; i < allowedIDs.size() && i < BooleanQuery.getMaxClauseCount(); ++i) {
            String id = allowedIDs.get(i);
            TermQuery q = new TermQuery(new Term("indexed_id", id));
            idQuery.add(q, BooleanClause.Occur.SHOULD);
            log.debug("makeQuery() - id added to idQuery: " + id);
        }
        BooleanQuery.Builder contextQuery = new BooleanQuery.Builder();
        contextQuery.add(query, BooleanClause.Occur.MUST);
        contextQuery.add(idQuery.build(), BooleanClause.Occur.FILTER);
        return contextQuery.build();
    }
}

